title vga13write.asm
; writing directly to video buffer in vga mode 13h (320x200).
; action: writes a 10x10 red square at position (160,100).
.model small
.stack 100h
.data
VIDEO_BUF equ 0A000h
NO_COLS equ 320
NO_ROWS equ 200
if1
	include ..\..\mac\basic.mac
endif
.code
main proc
	initdata	; macro
;
	mov ah,0	; set screen mode
	mov al,13h	; mode 13h
	int 10h
;
	mov ax,VIDEO_BUF
	mov es,ax
	mov bx,100
	mov ax,320	; bytes/row
	mul bx	; dx:ax=bx*ax
	add ax,160  ; ax has offset for (160,200) pixel
	mov si,ax
	;
	mov cx,10
	outer:
		save <cx,bx>
		mov cx,10
	inner: mov bx,cx
		mov es:[si+bx], byte ptr 4	; 4=read color
		loop inner
		add si,320
		restore <bx,cx>
		loop outer
	pause 'type a char to continue'
; restore mode
	mov ah,0
	mov al,3
	int 10h
;
	exitdos	; macro
main endp
	end main

		
	
	