
;************************************************************************
; Use BIOS to set up the EGA to display 512 different characters        *
; Entry:        CG_One  - Pointer to the first character generator      *
;               CG_Two  - Pointer to the second character generator     *
;************************************************************************

CG_One  EQU     [BP+4]
CG_Two  EQU     [BP+6]

        PUBLIC  _BIOS_512_Set

_BIOS_512_Set    PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    ES

        ;Download the two character generators

        MOV     AX,DS                   ;Assume both bitmaps are in DS seg
        MOV     ES,AX
        MOV     CX,256                  ;Download 256 characters
        MOV     DX,0                    ;Start with character 0
        MOV     BL,0                    ;Download as bitmaps 0 - 255
        MOV     BH,32                   ;Each bitmap is in 8x32 box
        PUSH    BP
        MOV     BP,CG_One               ;Pointer to first char gen
        MOV     AH,11H                  ;Function = CHARACTER GENERATOR
        MOV     AL,0                    ;Subfunction = LOAD CUSTOM SET
        INT     10H                     ;Ask BIOS to download first set
        POP     BP

        MOV     BL,1                    ;Download as bitmaps 256 - 511
        MOV     BP,CG_Two               ;Pointer to second char gen
        INT     10H                     ;Ask BIOS to download second set
        JMP     Set_Colors

        ;--- Since the INTENSIFY BIT will be used as generator select
        ;    we must load palette table to keep two halves the same

Default_Colors  DB      0,1,2,3,4,5,6,7, 0,1,2,3,4,5,6,7, 0
Default_Monos   DB      0,8,8,8,8,8,8,8, 0,8,8,8,8,8,8,8, 0
Set_Colors:
        LEA     DX,Default_Colors       ;Load offset of color palette
        XOR     AX,AX                   ;Look if mono display is attached
        MOV     ES,AX                   ;to see if mono palette is needed
        TEST    BYTE PTR ES:[BIOS_Equipment],2
        JZ      Default_In              ;... no, mono is not attached
        LEA     DX,Default_Monos        ;... yes, must use mono palette
Default_In:
        MOV     AX,CS                   ;Load segment of palette
        MOV     ES,AX
        MOV     AH,10H                  ;Function = LOAD PALETTE
        MOV     AL,2                    ;Subfunction = ALL REGS
        INT     10H                     ;Ask BIOS to load palette

        ;--- Enable two character generators

Enable_Two_CGs:
        MOV     BL,0100B                ;Register value for CHAR GEN SELECT
                                        ;This selects 0 for A and 1 for B
        MOV     AH,11H                  ;Function = CHARACTER GENERATOR
        MOV     AL,3                    ;Subfunction = SELECT ACTIVE SET
        INT     10H                     ;Ask BIOS to enable two sets
        JMP     Demo_Text

        ;--- Display few characters from each 256 character set

TestStr DB      'A', 7,'B', 7,'C', 7    ;Characters in   0 - 255
        DB      'A',15,'B',15,'C',15    ;Characters in 256 - 511

Demo_Text:
        MOV     AX,CS                   ;Segment of text
        MOV     ES,AX
        LEA     BP,TestStr              ;Offset of text
        MOV     BH,0                    ;Use page 0
        MOV     CX,6                    ;Display 6 characters
        MOV     DH,0                    ;Start at row 0
        MOV     DL,0                    ;and column 0
        MOV     AH,13H                  ;Function = WRITE TEXT STRING
        MOV     AL,03H                  ;Subfunction = CHAR+ATTRIB, UPDATE
        INT     10H                     ;Ask BIOS to write the string

        POP     ES
        POP     BP
        RET
_BIOS_512_Set   ENDP
