
;************************************************************************
; Use BIOS to get a pointer to the ROM base character generator         *
; Works only for standard text modes 0-3 and 7                          *
; returns zero for any other mode                                       *
; Exit: DX,AX   - Pointer to the character generator                    *
;************************************************************************

        PUBLIC  _BIOS_Get_ROM_CG

_BIOS_Get_ROM_CG PROC NEAR
        ;--- Fetch current mode

        PUSH    BP
        PUSH    ES                      ;Preserve segment registers
        XOR     AX,AX                   ;Point to BIOS data area
        MOV     ES,AX
        TEST    BYTE PTR ES:[BIOS_Equipment],2   ;Is mono display attached?
        JNZ     CG_8x14                 ;...Yes, go fetch 8x14 set
        CMP     BYTE PTR ES:[BIOS_Switch],9      ;Is Enhanced display attached?
        JE      CG_8x14                 ;...Yes, go fetch 8x14 set
        CMP     BYTE PTR ES:[BIOS_Switch],3
        JE      CG_8x14

        ;--- Return pointer to 8x8 character generator

CG_8x8:
        MOV     AH,11H                  ;Function = CHARACTER GENERATOR
        MOV     AL,30H                  ;Subfunction = GET INFO
        MOV     BH,3
        INT     10H                     ;Ask BIOS to fetch the pointer
        JMP     CG_Done

        ;--- Return pointer to 8x14 character generator
CG_8x14:
        MOV     AH,11H                  ;Function = CHARACTER GENERATOR
        MOV     AL,30H                  ;Subfunction = GET INFO
        MOV     BH,2
        INT     10H                     ;Ask BIOS to fetch the pointer
        JMP     CG_Done


        XOR     AX,AX                   ;Return zero for unknown modes
        MOV     ES,AX
        MOV     BP,AX

CG_Done:
        MOV     DX,ES                   ;Copy pointer into DX,AX pair
        MOV     AX,BP
        POP     ES
        POP     BP                      ;Restore segment registers
        RET
_BIOS_Get_ROM_CG ENDP
