
;************************************************************************
; Use BIOS to scroll whole screen                                       *
; Entry:        Count           - Number of lines to scroll             *
;************************************************************************

Count   EQU     BYTE PTR [BP+4]

        PUBLIC  _BIOS_Scroll_Page

_BIOS_Scroll_Page PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    ES
        XOR     AX,AX
        MOV     ES,AX

        MOV     BH,07                   ;Attribute for 'blank' lines
        MOV     AL,Count                ;Number of lines to scroll
        MOV     CH,0                    ;Upper left corner into CX
        MOV     CL,0
        MOV     DH,ES:[BIOS_Rows]       ;Lower right corner into DX
        DEC     DH
        MOV     DL,ES:[BIOS_Columns]
        DEC     DL
        CMP     Count,0                 ;Is scroll up?
        JL      B_Page_Down             ;...No, go scroll down
B_Page_Up:                              ;...Yes, load scroll down fn
        MOV     AH,06H                  ;Load service number
        JMP     B_Page_Scroll
B_Page_Down:
        MOV     AH,07H                  ;Load service number
        NEG     AL
B_Page_Scroll:
        INT     10H                     ;Call BIOS to do the scroll
        POP     ES
        POP     BP
        RET
_BIOS_Scroll_Page ENDP
