
;************************************************************************
; Determine primary adapter from BIOS variable in segment               *
; zero and return value in AX                                           *
; Exit: AX - Primary adapter type                                       *
;       1 => EGA is primary                                             *
;       2 => CGA is primary                                             *
;       3 => MDA or Hercules is primary                                 *
;************************************************************************

        PUBLIC  _Get_Primary

_Get_Primary    PROC NEAR
        PUSH    ES                      ;Preserve ES
        XOR     AX,AX                   ;Move segment zero into ES
        MOV     ES,AX
        MOV     BL,ES:[BIOS_Equipment]  ;Fetch info byte
        MOV     AX,1                    ;Assume EGA is primary
        TEST    BL,08H                  ;Is EGA primary?
        JZ      Primary_Found           ;...Yes, we are done
        MOV     AX,2                    ;...No, assume CGA is primary
        TEST    BL,02H                  ;Is mono attached to EGA?
        JNZ     Primary_Found           ;...Yes, we are done
        MOV     AX,3                    ;...No, must set AX to MDA
Primary_Found:
        POP     ES                      ;Restore ES
        RET
_Get_Primary    ENDP
