
;************************************************************************
; Determine display type from BIOS variables in segment zero            *
; and return value in AX                                                *
; Exit: AX - Display type                                               *
;       0 => None                                                       *
;       3 => Enhanced Display (or Multi-scan)                           *
;       4 => Color Display                                              *
;       5 => Monochrome Display                                         *
;       7 => VGA Monochrome                                             *
;       8 => VGA Color (or Multi-scan)                                  *
;************************************************************************

        PUBLIC  _Get_Display_Type

_Get_Display_Type       PROC NEAR
        PUSH    ES                      ;Preserve ES
        MOV     AX,1A00H                ;First look for VGA by trying fn=1A
        INT     10H
        CMP     AL,1AH                  ;There is no VGA if AL not 1A
        JNE     VGA_Not_There           ;...so go look for EGA
        MOV     AL,BL                   ;Return primary display info
        JMP     Found_Type

VGA_Not_There:
        XOR     AX,AX                   ;Move segment zero into ES
        MOV     ES,AX
        MOV     AL,5                    ;Assume monochrome display
        TEST    BYTE PTR ES:[BIOS_Equipment],2   ;Test if mono bit is ON
        JNZ     Found_Type              ;...Yes, we are done
                                        ;...No, must look at switches
        MOV     CL,ES:[BIOS_Switch]     ;Fetch switch settings
        AND     CL,0FH                  ;Isolate config switches
        MOV     AL,3                    ;Assume Enhanced display
        CMP     CL,9H                   ;Is switch 'off on on off'?
        JE      Found_Type              ;...Yes, we are done
        CMP     CL,3                    ;Is switch 'off off on on'?
        JE      Found_Type              ;...Yes, we are done
        MOV     AL,4                    ;...No, must be color display
Found_Type:
        XOR     AH,AH                   ;Clear AH
        POP     ES                      ;Restore ES
        RET
_Get_Display_Type       ENDP
