
;************************************************************************
; Get current number of rows and columns                                *
; Entry:Rows - Pointer to number of rows                                *
;       Cols - Pointer to number of columns                             *
; Exit: Values at the pointer will be set                               *
;************************************************************************

Rows    EQU     [BP+4]
Cols    EQU     [BP+6]

        PUBLIC  _Get_Rows_n_Cols

_Get_Rows_n_Cols PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    ES                      ;Preserve ES
        XOR     AX,AX                   ;Set ES to segment zero
        MOV     ES,AX
        MOV     DL,ES:[BIOS_Rows]       ;Fetch current rows
        INC     DL                      ;Adjust (since row-1 is stored)
        MOV     BX,Rows                 ;Fetch pointer
        XOR     DH,DH                   ;Clear upper half of DX
        MOV     [BX],DX                 ;Save number of rows
        MOV     CX,ES:[BIOS_Columns]    ;Fetch current columns
        MOV     BX,Cols                 ;Fetch pointer
        MOV     [BX],CX                 ;Save number of columns
        POP     ES
        POP     BP
        RET
_Get_Rows_n_Cols   ENDP
