title MSE-1	Basic Mouse Operations from Abel, p.392
	.model small
	.stack 64
	.data
xbin	dw	0	; binary x-coord
ybin	dw	0	; binary y-coord
ascval	dw	?	; ascii field
;	screen display fields
dispdata label byte
xmsg	db	'x = '	
xascii	dw	?	; x in ascii
	db	' '
ymsg	db	'y = '
yascii	dw	?	; y in ascii
	db	'$'
	.286
	.code
main	proc far
	mov ax,@data
	mov ds,ax
	call clear	; clear screen
	call init	; init mouse
	cmp ax,00	; mouse installed?
	je exit		; no, exit
again:
	call mseptr	; get mouse ptr location
	cmp bx,01	; button pressed?
	je done		; yes, get out of this loop
	call cursor	; set cursor
	mov ax,xbin
	call conv	; x to ascii
	mov ax,ascval
	mov xascii,ax	; save converted value in xascii
	mov ax,ybin
	call conv	; y to ascii
	mov ax,ascval
	mov yascii,ax	; save converted value in yascii
	call disp	; display x,y values
	jmp again
done:
	call hide	; hide mouse pointer
exit:	call clear	; clear screen
	mov ax,4c00h
	int 21h
main	endp

;	INIT MOUSE POINTER
;	------------------
init	proc near
	mov ax,00h	; initialize mse function
	int 33h
	cmp ax,00	; mse installed?
	je nomse	; no, exit
	mov ax,01h	; show mse pointer
	int 33h
nomse:	ret
init	endp

;	GET MOUSE POINTER LOCATION
;	--------------------------
mseptr	proc near
more:	mov ax,03h	; get mse ptr location function
	int 33h
	cmp bx,01	; right button pressed?
	je return	; yes, means return
	shr cx,03	; divide pixel value
	shr dx,03	;    by 8
	cmp cx,xbin	; has ptr location
	jne changed	;    changed?
	cmp dx,ybin
	je more		; if not, repeat
changed: mov xbin,cx	; if yes, save new location
	mov ybin,dx
return: ret
mseptr	endp

;	CONVERT BINARY TO ASCII
;	-----------------------
conv	proc near	; input: ax in binary
	mov ascval,2020h ; clear ascii field
	mov cx,10	; set divide factor
	lea si,ascval+1	; load ascval address
	cmp ax,cx	; compare location to 10
	jb lower	; if lower, bypass
	div cl		; if higher, divide by 10
	or ah,30h	; insert ASCII 3s
	mov [si],ah	; store in rightmost byte
	dec si	
lower:	or al,30h	; insert ASCII 3s
	mov [si],al	; store in leftmost byte
	ret
conv	endp

;	HIDE MOUSE POINTER (before ending)
;	----------------------------------
hide	proc near
	mov ax,02h	; hide function
	int 33h
	ret
hide	endp

;	CLEAR SCREEN
;	------------
clear	proc near
	mov ax,0600h	; request clear screen
	mov bh,30h	; colors
	mov cx,00	; full
	mov dx,184fh	;   screen
	int 10h
	ret
clear 	endp

;	SET TEXT CURSOR
;	---------------
cursor	proc near
	mov ah,02h	; set cursor position function
	mov bh,0	; page 0
	mov dh,0	; row
	mov dl,25	; col
	int 10h
	ret
cursor	endp

;	DISPLAY MOUSE POSITION
;	----------------------
disp	proc near
	mov ah,9h	; display function
;	mov bx,01	; screen handle?
;	mov cx,14	; number of characters
	lea dx,dispdata	; display data
	int 21h
	ret
disp	endp
	end main
