; THESE ARE GENERAL ASSEMBLY MACROS
; Prepared by CHEE YAP for Comp.Sys.Org.Class (fall 1996)
;       They are organized into groups:
;       -- I/O routines
;       -- basic programming constructs
;       -- dos routines
; These groups are preceded by double semicolons, ";;"
; To include these macros, put at the beginning of
;       your code the lines
;               IF1
;               INCLUDE ..\MAC\MAC.ASM
;               ENDIF
;	assuming that this file is MAC.ASM in the directory ..\MAC.

;; I/O ROUTINES

COMMENT +
	Print char in byte register or variable
	Synopsis:
			PutChar <byte-variable>
	E.g., PutChar BL
END COMMENT  +
PutChar MACRO reg
	push ax
	push dx
	mov dl,reg
	mov ah,2
	int 21h
	pop dx
	pop ax
	endm

COMMENT +
	Print CR,LF
	E.g., new_line
END COMMENT +
new_line MACRO
	push ax
	push dx
	mov ah,2
	mov dl,0dh
	int 21h
	mov dl,0ah
	int 21h
	pop dx
	pop ax
	endm

COMMENT +
	Display String Macro
	Synopsis:
		DISP_STR <string>
	will print <string> on the screen.
	E.g.    DISP_STR 'Hello World!'
END COMMENT +           
DISP_STR MACRO string
	LOCAL start,msg
; save reg:
	push ax
	push dx
	push ds
	jmp start
msg     db      STRING,'$'
start:  mov ax,cs
	mov ds,ax       ; set ds to code segment
	mov ah,9
	lea dx,msg
	int 21h
; restore reg
	pop ds
	pop dx
	pop ax
	endm

;; Programming constructs

COMMENT +
	Save any number of registers
	Synopsis:
		SAVE_REGS <...>
		will save the specified registers within angle brackets.
	E.g. SAVE_REGS <AX,BX,SI,DI>
END COMMENTS +
SAVE_REGS MACRO REGS
	IRP D, <REGS>
	PUSH D
	ENDM
	ENDM

COMMENT +
	Restore any number of registers
	Synopsis:
		RESTORE_REGS <...>
		will restore the registers.
	E.g. RESTORE_REGS <DI,SI,BX,AX>
END COMMENTS +
RESTORE_REGS MACRO regs
	irp d,<regs>
	pop d
	endm
	endm
	
COMMENT +
	Initialize DS register to @DATA
END COMMENTS +
INIT_DS	MACRO
	push ax
	mov ax,@DATA
	mov ds, ax
	pop ax
	endm

;; DOS ROUTINES

COMMENT +
	Return to DOS Macro
	Synopsis:
		DOS_RTN <val>
		will return to dos the value <val> (which is an integer)
	E.g., DOS_RTN 0
END COMMENT +
DOS_RTN MACRO value
	mov ah,4ch
	mov al,value
	int 21h
	endm


	

