; This is program pgm15_3b.asm (p.324 of text)
;
title prm15_3b: save screen and cursor
;
EXTRN		ss_buf:byte
PUBLIC		save_screen, restore_screen, set_cursor
c_seg segment	PUBLIC
	assume cs:c_seg
;
save_screen PROC
; saves 8 chars from upper right hand corner
	lea si,ss_buf	; screen buffer
	mov cx,8	; repeat 8 times
	mov dl,72	; column 72
	cld		; clear df for string op
ss_loop:
	call set_cursor	; setup cursor at row 0, col dl
	mov ah,08h	; read char on screen
	int 10h		; ah=attribute, al=char
	stosw		; stores char and attribute
	inc  dl		; new col
	loop ss_loop
	ret
save_screen endp
;
restore_screen PROC
; restores saved screen
	lea si,ss_buf	; si points to buf
	mov dl,8	; repeat 8 times
	mov dl,72	; col 72
	mov cx,1	; 1 char at a time
rs_loop:
	call set_cursor	; move cursor
	lodsw		; ah=attribute, al=char
	mov bl,ah	; bl has attribute
	mov ah, 09h	; function 9, write char and attribute
	mov bh, 0	; page 0
	int 10h
	inc dl		; next char pos
	dec di		; mov char?
	jg rs_loop	;  yes, repeat
	ret
restore_screen endp
;
set_cursor PROC
; sets cursor at row 0, col dl
; input dl=col number
	mov ah,02	; function 2, set cursor
	mov bh,0	; pg 0
	mov dh,0	; row 0
	int 10h
	ret
set_cursor endp
;
c_seg ends
	end

	
