TITLE GAME2A
EXTRN   WHICH_COUNTRY:BYTE, COURT_TYPE:BYTE, DISPLAY_COUNTRY
PUBLIC SET_DISPLAY_MODE, DISPLAY_BALL

.MODEL SMALL

;draw a line in row x from column 10 to column 300


DRAW_ROW MACRO X
LOCAL L1

	MOV AH,0CH
	MOV AL,3  
	MOV CX,10 
	MOV DX,X                   
L1:
	INT 10H
	INC CX    
	CMP CX,301
	JL L1     
	ENDM

;the following macro is used to draw a long line for the net (the vertical lines)

DRAW_NEW_COLUMN MACRO 
LOCAL TOP

	PUSH DX                           ;save dx
	PUSH BX                           ;save bx
	MOV AH, 0CH                       ;draw pixel
	MOV BX, 141                       ;move length into bx                 
TOP:
	INT 10H
	INC DX                            ;move down one row
	DEC BX                            ;keep track of length, reduce by one
	JNZ TOP                           ;if not finished, repeat
	POP BX                            ;restore bx
	POP DX                            ;restore dx
	ENDM

;the following macro is used to draw the angular lines that compose the
;net.  Its called repeatedly to draw each layer of lines.


DRAW_ANGLE_LINE MACRO Z
LOCAL TOP


	PUSH DX                           ;save dx
	PUSH CX                           ;save cx
	PUSH BX                           ;save bx
	MOV AH, 0CH                       ;draw pixel
	MOV BX, Z                         ;put length in bx
TOP:
	INT 10H
	INC DX                            ;move over down one row
	DEC CX                            ;move over one column
	DEC BX                            ;keep track of length of edge
	CMP BX, 0                         ;finished edge?
	JNE TOP                           ;if not finished, repeat.

	POP BX                            ;restore bx
	POP CX                            ;restore cx
	POP DX                            ;restore dx
	ENDM

;This macro simply draws the border(column).

DRAW_COLUMN MACRO Y
LOCAL L2

	MOV AH,0CH              ;draw pixel
	MOV AL,3
	MOV CX,Y                ;column y
	MOV DX,10               ;row 10
L2:
	INT 10H
	INC DX                  ;next row
	CMP DX,190              ;beyond row 189?
	JL L2                   ;no, repeat
	ENDM

.CODE

SET_DISPLAY_MODE PROC
;sets display mode and drwas boundry
;input: court_type is the number 1 through 5 which indicates which court user
;selects
;output: creates broundry, background and the net

	CMP COURT_TYPE, 1                ;did user choose fire?
	JE  FIRE                         ;jump to fire if so
	CMP COURT_TYPE, 2                ;did user choose water?
	JE  WATER                        ;jump to water if so
	CMP COURT_TYPE, 3                ;did user choose street?
	JE  STREET                       ;jump to street if so
	CMP COURT_TYPE, 4                ;did user choose beach?
	JE  BEACH                        ;jump to beach if so
	CMP COURT_TYPE, 5                ;did user choose grass?
	JE  GRASS                        ;jump to grass if so

FIRE:
	CALL DISPLAY_FIRE        ;call display_fire
	JMP CONTIN               ;skip over rest till contin
WATER:
	CALL DISPLAY_WATER       ;call display_water
	JMP CONTIN               ;skip over rest till contin
STREET:
	CALL DISPLAY_STREET      ;call display_street 
	JMP CONTIN               ;skip over rest till contin
BEACH:
	CALL DISPLAY_BEACH       ;call display_beach
	JMP CONTIN               ;skip over rest till contin
GRASS:
	CALL DISPLAY_GRASS       ;call display_grass
	JMP CONTIN               ;skip over rest till contin


CONTIN:                          ;draws boundry
	DRAW_ROW 6               ;draws row at 6
	DRAW_ROW 10              ;draws row at 10
	DRAW_ROW 189             ;draws row at 189
	DRAW_ROW 193             ;draws row at 193
	DRAW_COLUMN 6            ;draws column at 6
	DRAW_COLUMN 10           ;draws column at 10
	DRAW_COLUMN 300          ;draws column at 300
	DRAW_COLUMN 304          ;draws column at 304

;DRAW NET BEGIN:                 ;draws net

	MOV CX, 155              ;draw net at column 155
	MOV DX, 11               ;draw net at row 11
	MOV BX, 46               ;BX holds the number of angular lines that
				 ;will be drawn within the net.


	DRAW_ANGLE_LINE 40       ;draw angle line of net of length 40

NEW_NET:
	ADD DX, 3                 ;the angular lines of the net that
	DRAW_ANGLE_LINE 17        ;compose the net are drawn every 3 rows.
	DEC BX                    ;decrement counter.
	CMP BX, 0
	JNZ NEW_NET

	MOV BX, 6                 ;BX once again represents a counter.

	DRAW_ANGLE_LINE 40        ;The angular line is 40 pixels long
	MOV DX, 10
	MOV CX, 155

NET_LINE:
	DRAW_NEW_COLUMN           
	SUB CX, 3
	ADD DX, 3                 ;These subs and adds are needed to
	DEC BX                    ;draw the lines accordingly (the long lines).
	CMP BX, 0
	JNZ NET_LINE

;DRAW NET END


	RET

SET_DISPLAY_MODE ENDP

DISPLAY_BALL PROC

;Input AL = color of ball (either background (0) or color).
;      CX = column to begin drawing.
;      DX = row to begin drawing.
;Output: a drawn 6X6 ball starting at the position dictated by CX and DX. 
;        if AL = 0 then the ball is erased...if its 1 then its drawn.
;Method: The procedure increments and decrements CX and DX according to a
;        graphical method to draw what resembles to the user a ball graphic.


	MOV AH,0CH      ;draw pixel function
	
	PUSH CX
	PUSH DX
			;FIRST COLUMN         

	INT 10H         ;DX and CX will be increased and decreased according
	INC DX          ;to a graph.
	INT 10H
	
	INC CX ;NEXT COLUMN (#2)
	
	INC DX
	INT 10H
	DEC DX
	INT 10H
	DEC DX
	INT 10H
	DEC DX
	INT 10H
	    
	INC CX ;NEXT COLUMN (#3)

	DEC DX
	INT 10H
	INC DX
	INT 10H
	INC DX
	INT 10H
	INC DX
	INT 10H
	INC DX
	INT 10H
	INC DX
	INT 10H

	INC CX ;NEXT COLUMN (#4)

	INT 10H
	DEC DX
	INT 10H
	DEC DX
	INT 10H
	DEC DX
	INT 10H
	DEC DX
	INT 10H
	DEC DX
	INT 10H

	INC CX ;NEXT COLUMN (#5)
	
	INC DX
	INT 10H
	INC DX
	INT 10H
	INC DX
	INT 10H
	INC DX
	INT 10H
	
	INC CX ;NEXT COLUMN (#6)

	DEC DX
	INT 10H
	DEC DX
	INT 10H

	POP DX
	POP CX
       
	RET

DISPLAY_BALL ENDP

;the following procedures are all similar.  Refer to first procedure for
;comments.

DISPLAY_GRASS PROC
;sets display mode, background color and palette

	MOV AH,0        ;Set mode function.
	MOV AL,04H      ;mode 4
	INT 10H
	MOV AH,0BH      ;set background/palette function.
	MOV BH,1        ;palette
	MOV BL,1        ;palette 1
	INT 10H
	MOV BH,0        ;background
	MOV BL,2        ;green
	INT 10H
	RET

DISPLAY_GRASS ENDP

DISPLAY_WATER PROC

	MOV AH,0
	MOV AL,04H
	INT 10H
	MOV AH,0BH
	MOV BH,1       ;palette 1
	MOV BL,1
	INT 10H
	MOV BH,0
	MOV BL,1        ;blue background
	INT 10H
	RET
DISPLAY_WATER ENDP

DISPLAY_FIRE PROC

	MOV AH,0
	MOV AL,04H
	INT 10H
	MOV AH,0BH
	MOV BH,1
	MOV BL,1        ;palette
	INT 10H
	MOV BH,0
	MOV BL,4        ;red background
	INT 10H
	RET
DISPLAY_FIRE ENDP

DISPLAY_STREET PROC

	MOV AH,0
	MOV AL,04H
	INT 10H
	MOV AH,0BH
	MOV BH,1
	MOV BL,1        ;palette
	INT 10H
	MOV BH,0
	MOV BL,8        ;gray background
	INT 10H
	RET
DISPLAY_STREET ENDP

DISPLAY_BEACH PROC

	MOV AH,0
	MOV AL,04H
	INT 10H
	MOV AH,0BH
	MOV BH,1
	MOV BL,1         ;palette
	INT 10H
	MOV BH,0
	MOV BL,14        ;yello background
	INT 10H
	RET
DISPLAY_BEACH ENDP



END
