EXTRN  BLUE:byte,GREEN:byte,CYAN:byte,RED:byte,PURPLE:byte
EXTRN  BROWN:byte,WHITE:byte,GRAY:byte,LIGHT_BLUE:byte
EXTRN  LIGHT_GREEN:byte,LIGHT_CYAN:byte,LIGHT_RED:byte,
EXTRN  LIGHT_MAGENTA:byte,YELLOW:byte, INT_WHITE:byte
EXTRN  buildings, buildings_p, n_buildings:byte
EXTRN  planes_hit:byte, buildings_hit:byte, max_planes_hit:byte
EXTRN  end_game_code

EXTRN  Score2dec:NEAR

PUBLIC GameOver

        .MODEL  SMALL
        .STACK  200h
;-----------------------------------------------------------------------

INCLUDE GRAPHS.LIB           ; Includes file with graph-mode macros
INCLUDE IMAGES.LIB           ; Includes the routines that will draw
INCLUDE MY_MACRO.LIB
                             ; the images.
;------DATA SEGMENT----------------------------------------------------
        .DATA
esc_message     DB 10,13,'The game was terminated by pressing ESC-key.$'
gun_message     DB 10,13,'The gun has been destroyed. You have lost. $'
b_message DB 10,13,'All your buildings have been destroyed. You have lost. $'
score_message   DB 10,13,'Your score is : $'

;-----------------------------------------------------------------------
        .CODE
GameOver  PROC  
        push    ax
        push    bx
        push    cx                       ; Saving Registers
        push    dx
        push    ds

        mov     ax,@DATA                ; Initialize data segment
        mov     ds,ax

        set_screen_mode  3              ; Set Screen to Graphic mode
        clear_screen                    ; Clear screen macro

        cmp     end_game_code,1         ; CASE <ESC> was pressed
        jne     lost_gun                ; 
        move_cursor     11,0,0          ; set cursor
        print_string    esc_message     ; print message
        jmp     report                  ; 
lost_gun:                               ; CASE gun was destroyed
        cmp     end_game_code,2         ;
        jne     lost_buildings          ;
        move_cursor     11,0,0          ;  set cursor
        print_string    gun_message     ;  print message
        jmp     report                  ;
lost_buildings:                         ;  CASE buildings were destroyed
        move_cursor     11,0,0          ;  set cursor
        print_string    b_message       ;  print message
report:                                 ;
        move_cursor   12,0,0            ; Set cursor
        print_string score_message      ; Print message
        call          score2dec         ; Call procedure to print score in 
                                        ; ASCII
        pop     ds                      ;
        pop     dx                      ;
        pop     cx                      ; Restoring registers
        pop     bx                      ;
        pop     ax                      ;

        ret                           ; Return to Main module  
GameOver  ENDP                        ; End of GameOver procedure
END

 
