;ChoongHong Oh

TITLE PGM9: COLLISION
        EXTRN ARROW1 : WORD, ARROW2 : WORD
        EXTRN NO_F_ENE : BYTE
        EXTRN F_ENE1 : WORD, F_ENE2 : WORD, F_ENE3 : WORD
        EXTRN F_ENE4 : WORD, F_ENE5 : WORD
        EXTRN AUX_X : WORD, AUX_Y : WORD
        EXTRN SCORE : BYTE, SCORING : NEAR
        EXTRN BEEP : NEAR
        PUBLIC COLLISION


.MODEL SMALL
IF1
        INCLUDE G_MACRO.ASM
ENDIF

.CODE

CHECK_COLLISION PROC
;this procedure checks if there is any collision
;between a faaling enemy at (AUX_X, AUX_Y) and ARROW1 or ARROW2
;if so, this procedure erases both the falling enemy and the arrow
;and makes a beep and update a score and decrements the number of falling enemies
;if not, this procedure does not do anything
;input:(AUX_X, AUX_Y) is a coordinate of a falling enemy

        SAVE_REGS <AX, BX>
        CMP AUX_X, 0FFFFh        ;if this F_ENE is used,
        JNZ CHECK_ARROW1         ;then,  check if there is collision
        JMP DONE                 ;else, check the next F_ENE

;check collision with ARROW1
CHECK_ARROW1:
        MOV AX, AUX_X
        MOV BX, AUX_Y

        CMP AX, ARROW1
        JG  CHECK_ARROW2

        ADD AX, 32
        CMP AX, ARROW1
        JL  CHECK_ARROW2

        CMP BX, ARROW1+2
        JG  CHECK_ARROW2

        ADD BX, 48
        CMP BX, ARROW1+2
        JL  CHECK_ARROW2
        JMP COLLIDE1

CHECK_ARROW2:
        MOV AX, AUX_X
        MOV BX, AUX_Y
        CMP AX, ARROW2
        JG  NO_COLLISION

        ADD AX, 32
        CMP AX, ARROW2
        JL  NO_COLLISION

        CMP BX, ARROW2+2
        JG  NO_COLLISION

        ADD BX, 48
        CMP BX, ARROW2+2
        JL  NO_COLLISION
        JMP COLLIDE2

NO_COLLISION:
        JMP DONE

COLLIDE1:
        ERASE_F_KNIGHT AUX_X, AUX_Y  ;erase this F_ENE
        ERASE_ARROW ARROW1, ARROW1+2 ;erase ARROW1
        MOV AUX_X, 0FFFFh            ;delete this F_ENE
        MOV AUX_Y, 0FFFFh   
        MOV ARROW1, 0FFFFh           ;delete ARROW1
        MOV ARROW1+2, 0FFFFh         
        DEC NO_F_ENE          ;decrement the number of F_ENE
        CALL BEEP             ;make a BEEP
        INC SCORE             ;increment SCORE
        CALL SCORING          ;display new SCORE
        JMP DONE

COLLIDE2:
        ERASE_F_KNIGHT AUX_X, AUX_Y  ;erase this F_ENE
        ERASE_ARROW ARROW2, ARROW2+2 ;erase ARROW2
        MOV AUX_X, 0FFFFh            ;delete this F_ENE
        MOV AUX_Y, 0FFFFh   
        MOV ARROW2, 0FFFFh           ;delete ARROW2
        MOV ARROW2+2, 0FFFFh         
        DEC NO_F_ENE          ;decrement the number of F_ENE
        CALL BEEP             ;make a BEEP
        INC SCORE             ;increment SCORE
        CALL SCORING          ;display new SCORE
DONE:
        RESTORE_REGS <BX, AX>

        RET
CHECK_COLLISION ENDP

COLLISION PROC
;this procedure procedure checks all the possible position
;and if collision happens, this procedure updates necesaary information

        PUSH AX
;prepare to call CHECK_COLLISION for F_ENE1
        MOV AX, F_ENE1     ;pass X-coordinate of F_ENE1  
        MOV AUX_X, AX      ;to AUX_X
        MOV AX, F_ENE1+2   ;pass Y_coordinate of F_ENE1
        MOV AUX_Y, AX      ;to AUX_Y
        CALL CHECK_COLLISION
        MOV AX, AUX_X      ;pass back the value of AUX_X
        MOV F_ENE1, AX     ;to X-coordinate of F_ENE1
        MOV AX, AUX_Y      ;pass back the value of AUX_Y
        MOV F_ENE1+2, AX   ;to Y-coordinate of F_ENE1
;prepare to call CHECK_COLLISION for F_ENE2
        MOV AX, F_ENE2     ;pass X-coordinate of F_ENE2  
        MOV AUX_X, AX      ;to AUX_X
        MOV AX, F_ENE2+2   ;pass Y_coordinate of F_ENE2
        MOV AUX_Y, AX      ;to AUX_Y
        CALL CHECK_COLLISION
        MOV AX, AUX_X      ;pass back the value of AUX_X
        MOV F_ENE2, AX     ;to X-coordinate of F_ENE2
        MOV AX, AUX_Y      ;pass back the value of AUX_Y
        MOV F_ENE2+2, AX   ;to Y-coordinate of F_ENE2
;prepare to call CHECK_COLLISION for F_ENE3
        MOV AX, F_ENE3     ;pass X-coordinate of F_ENE3  
        MOV AUX_X, AX      ;to AUX_X
        MOV AX, F_ENE3+2   ;pass Y_coordinate of F_ENE3
        MOV AUX_Y, AX      ;to AUX_Y
        CALL CHECK_COLLISION
        MOV AX, AUX_X      ;pass back the value of AUX_X
        MOV F_ENE3, AX     ;to X-coordinate of F_ENE3
        MOV AX, AUX_Y      ;pass back the value of AUX_Y
        MOV F_ENE3+2, AX   ;to Y-coordinate of F_ENE3
;prepare to call CHECK_COLLISION for F_ENE4
        MOV AX, F_ENE4     ;pass X-coordinate of F_ENE4  
        MOV AUX_X, AX      ;to AUX_X
        MOV AX, F_ENE4+2   ;pass Y_coordinate of F_ENE4
        MOV AUX_Y, AX      ;to AUX_Y
        CALL CHECK_COLLISION
        MOV AX, AUX_X      ;pass back the value of AUX_X
        MOV F_ENE4, AX     ;to X-coordinate of F_ENE4
        MOV AX, AUX_Y      ;pass back the value of AUX_Y
        MOV F_ENE4+2, AX   ;to Y-coordinate of F_ENE4
;prepare to call CHECK_COLLISION for F_ENE5
        MOV AX, F_ENE5     ;pass X-coordinate of F_ENE5  
        MOV AUX_X, AX      ;to AUX_X
        MOV AX, F_ENE5+2   ;pass Y_coordinate of F_ENE5
        MOV AUX_Y, AX      ;to AUX_Y
        CALL CHECK_COLLISION
        MOV AX, AUX_X      ;pass back the value of AUX_X
        MOV F_ENE5, AX     ;to X-coordinate of F_ENE5
        MOV AX, AUX_Y      ;pass back the value of AUX_Y
        MOV F_ENE5+2, AX   ;to Y-coordinate of F_ENE5

        POP AX
        RET
COLLISION ENDP
        END

