;ChoongHong Oh

TITLE PGM7: F_ENEMY
        EXTRN NO_F_ENE : BYTE, GRAPHIC_F_ENE : BYTE 
        EXTRN F_ENE1 : WORD, F_ENE2 : WORD, F_ENE3 : WORD
        EXTRN F_ENE4 : WORD, F_ENE5 : WORD
        EXTRN NO_W_ENE : BYTE 
        EXTRN W_ENE1 : WORD, W_ENE2 : WORD, W_ENE3 : WORD
        EXTRN W_ENE4 : WORD, W_ENE5 : WORD
        EXTRN AUX_X : WORD, AUX_Y : WORD
        PUBLIC MOVE_F_ENEMY


.MODEL SMALL
IF1
        INCLUDE G_MACRO.ASM
ENDIF

.CODE

DRAW_F_KNIGHT PROC
;this procedure draws a falling knight  at (AUX_X, AUX_Y)
;by using the right macro according to the graphic number
;input:(AUX_X, AUX_Y) is the coordinate of a falling knight

        CMP GRAPHIC_F_ENE, 0    ;the graphic number of F_ENE  =  0?
        JE NO_0
        JMP NO1                 ;no, check if it is 1
NO_0:
        F_KNIGHT1  AUX_X, AUX_Y ;yes, draw F_ENE using F_KNIGHT1
        JMP DONE                ;this procedure is done
NO1:
        CMP GRAPHIC_F_ENE, 1    ;the graphic number of F_ENE  =  1?
        JE NO_1
        JMP NO2                 ;no, check if it is 2
NO_1:
        F_KNIGHT2  AUX_X, AUX_Y ;yes, draw F_ENE using F_KNIGHT2
        JMP DONE                ;this procedure is done
NO2:
        CMP GRAPHIC_F_ENE, 2    ;the graphic number of F_ENE  =  2?
        JE NO_2
        JMP NO3                 ;no, check if it is 3
NO_2:
        F_KNIGHT3  AUX_X, AUX_Y ;yes, draw F_ENE using F_KNIGHT3
        JMP DONE                ;this procedure is done
NO3:                            ;the graphic number  = 3
        F_KNIGHT2  AUX_X, AUX_Y ;yes, draw F_ENE using F_KNIGHT2

DONE:
        RET
DRAW_F_KNIGHT ENDP

UPDATE_F_ENE  PROC 
;this procedure checks if a falling knight is used or not
;if it is not used, this procedure does not do anything
;if it is used, this procedure erases a knight at the current position
;and updates the coordinate and draw a knight at the new point
;input:(AUX_X, AUX_Y) is the coordinate of a falling knight

        CMP AUX_X, 0FFFFh            ;if this F_ENE is not used,
        JZ DONE_                     ;then, check the next F_ENE
        ERASE_F_KNIGHT AUX_X, AUX_Y  ;erase this F_ENE
        ADD AUX_Y, 10                ;else move down this F_ENE
        CMP AUX_Y, 368               ;if this F_ENE has reached the ground
        JL DRAW_F_ENE
        CALL F_ENE2_W_ENE
        MOV AUX_X, 0FFFFh    ;delete this F_ENE
        MOV AUX_Y, 0FFFFh   
        DEC NO_F_ENE
        JMP DONE_            ;then check the next F_ENE
DRAW_F_ENE:
        CALL DRAW_F_KNIGHT 
DONE_:
        RET
UPDATE_F_ENE ENDP

MOVE_F_ENEMY PROC
;this procedure updates all the falling knights and the graphic number
;by calling UPDATE_F_ENE procedure, having AUX_X and AUX_Y as parameters

        PUSH AX
;prepare to call UPDATE_F_ENE for F_ENE1
        MOV AX, F_ENE1     ;pass X-coordinate of F_ENE1  
        MOV AUX_X, AX      ;to AUX_X
        MOV AX, F_ENE1+2   ;pass Y_coordinate of F_ENE1
        MOV AUX_Y, AX      ;to AUX_Y
        CALL UPDATE_F_ENE
        MOV AX, AUX_X      ;pass back the value of AUX_X
        MOV F_ENE1, AX     ;to X-coordinate of F_ENE1
        MOV AX, AUX_Y      ;pass back the value of AUX_Y
        MOV F_ENE1+2, AX   ;to Y-coordinate of F_ENE1
;prepare to call UPDATE_F_ENE for F_ENE2
        MOV AX, F_ENE2     ;pass X-coordinate of F_ENE2  
        MOV AUX_X, AX      ;to AUX_X
        MOV AX, F_ENE2+2   ;pass Y_coordinate of F_ENE2
        MOV AUX_Y, AX      ;to AUX_Y
        CALL UPDATE_F_ENE
        MOV AX, AUX_X      ;pass back the value of AUX_X
        MOV F_ENE2, AX     ;to X-coordinate of F_ENE2
        MOV AX, AUX_Y      ;pass back the value of AUX_Y
        MOV F_ENE2+2, AX   ;to Y-coordinate of F_ENE2
;prepare to call UPDATE_F_ENE for F_ENE3
        MOV AX, F_ENE3     ;pass X-coordinate of F_ENE3  
        MOV AUX_X, AX      ;to AUX_X
        MOV AX, F_ENE3+2   ;pass Y_coordinate of F_ENE3
        MOV AUX_Y, AX      ;to AUX_Y
        CALL UPDATE_F_ENE
        MOV AX, AUX_X      ;pass back the value of AUX_X
        MOV F_ENE3, AX     ;to X-coordinate of F_ENE3
        MOV AX, AUX_Y      ;pass back the value of AUX_Y
        MOV F_ENE3+2, AX   ;to Y-coordinate of F_ENE3
;prepare to call UPDATE_F_ENE for F_ENE4
        MOV AX, F_ENE4     ;pass X-coordinate of F_ENE4  
        MOV AUX_X, AX      ;to AUX_X
        MOV AX, F_ENE4+2   ;pass Y_coordinate of F_ENE4
        MOV AUX_Y, AX      ;to AUX_Y
        CALL UPDATE_F_ENE
        MOV AX, AUX_X      ;pass back the value of AUX_X
        MOV F_ENE4, AX     ;to X-coordinate of F_ENE4
        MOV AX, AUX_Y      ;pass back the value of AUX_Y
        MOV F_ENE4+2, AX   ;to Y-coordinate of F_ENE4
;prepare to call UPDATE_F_ENE for F_ENE5
        MOV AX, F_ENE5     ;pass X-coordinate of F_ENE5  
        MOV AUX_X, AX      ;to AUX_X
        MOV AX, F_ENE5+2   ;pass Y_coordinate of F_ENE5
        MOV AUX_Y, AX      ;to AUX_Y
        CALL UPDATE_F_ENE
        MOV AX, AUX_X      ;pass back the value of AUX_X
        MOV F_ENE5, AX     ;to X-coordinate of F_ENE5
        MOV AX, AUX_Y      ;pass back the value of AUX_Y
        MOV F_ENE5+2, AX   ;to Y-coordinate of F_ENE5

;change the graphic number
        CMP GRAPHIC_F_ENE, 3 ;if the graphic number is 3,
        JE CLEAR             ;then, clear it
        INC GRAPHIC_F_ENE    ;else, increment it by 1
        JMP END_
CLEAR:
        MOV GRAPHIC_F_ENE, 0 ;clear the graphic number
END_:
        POP AX
        RET
MOVE_F_ENEMY ENDP

F2W MACRO X1, X2
;this macro exchanges X1 and X2
;and add 32 to X2
        PUSH AX
        MOV AX, X1
        SUB AX, 32
        MOV X2, AX
        POP AX
        ENDM

F_ENE2_W_ENE PROC
;this procedure is called when a falling enemy reaches the ground
;and passes its X-coordinate to a walking enemy which is not used at the time
;by finding a walking enemy which is not used
;and increments the number of walking enemies
;input:AUX_X is the coodinate of a falling enemy

;check if W_ENE1 is used
        CMP W_ENE1, 0FFFFh  ;if W_ENE1 is used,
        JNE W2             ;then, check W_ENE2
        F2W AUX_X, W_ENE1  ;otherwise, pass X-coordinate of F_ENE to W_ENE1
        JMP DONE_F2W

;check if W_ENE2 is used
W2:
        CMP W_ENE2, 0FFFFh  ;if W_ENE2 is used,
        JNE W3             ;then, check W_ENE2
        F2W AUX_X, W_ENE2  ;otherwise, pass X-coordinate of F_ENE to W_ENE2
        JMP DONE_F2W
;check if W_ENE3 is used
W3:
        CMP W_ENE3, 0FFFFh  ;if W_ENE3 is used,
        JNE W4             ;then, check W_ENE3
        F2W AUX_X, W_ENE3  ;otherwise, pass X-coordinate of F_ENE to W_ENE3
        JMP DONE_F2W
;check if W_ENE4 is used
W4:
        CMP W_ENE4, 0FFFFh  ;if W_ENE4 is used,
        JNE W5             ;then, check W_ENE4
        F2W AUX_X, W_ENE4  ;otherwise, pass X-coordinate of F_ENE to W_ENE4
        JMP DONE_F2W
;check if W_ENE5 is used
W5:
        CMP W_ENE5, 0FFFFh  ;if W_ENE5 is used,
        JNE DONE_F2W       ;then, check W_ENE5
        F2W AUX_X, W_ENE5  ;otherwise, pass X-coordinate of F_ENE to W_ENE5
        JMP DONE_F2W
DONE_F2W:
        INC NO_W_ENE
        RET
F_ENE2_W_ENE ENDP
        END

