;ChoongHong Oh
;GRAPHIC TOOL MACRO

IF1
        INCLUDE macro.ASM
ENDIF

DRAW_PIXEL MACRO X, Y, X1, Y1, COLOR
;this macro draws a pixel at (X+X1, Y+Y1)
;in a color of COLOR
;X, Y are variables (might be 0)
;X1, Y1 are constants
        SAVE_REGS <AX, CX, DX>
        MOV AH, 0Ch   ;draw pixel
        MOV AL, COLOR ;set color
        MOV CX, X
        ADD CX, X1    ;column X1
        MOV DX, Y
        ADD DX, Y1     ;row Y1
        INT 10h
        RESTORE_REGS <DX, CX, AX>
        ENDM

DRAW_DIAGONAL1 MACRO X, Y, X1, X2, Y1, COLOR
        LOCAL L1, DONE
;this macro draws a diagonal line segment
;between (X+X1, Y+Y1) and (X+X2, Y+Y1-[X2-X1])
;in a color of COLOR
;X, Y are variables (might be 0)
;X1, X2, Y1 are constants
        SAVE_REGS <AX, BX, CX, DX>
        MOV AH, 0Ch   ;draw pixel
        MOV AL, COLOR ;set color
        MOV CX, X
        ADD CX, X1    ;from column X1
        MOV DX, Y
        ADD DX, Y1    ;from row Y1
L1:
        MOV BH, 0     ;page 0
        INT 10h
        INC CX
        INC DX
        MOV BX, X
        ADD BX, X2    ;to column X2
        INC BX
        CMP CX, BX
        JE DONE
        JMP L1
DONE:
        RESTORE_REGS <DX, CX, BX, AX>
        ENDM

DRAW_DIAGONAL2 MACRO X, Y, X1, X2, Y1, COLOR
        LOCAL L1, DONE
;this macro draws a diagonal line segment
;between (X+X1, Y+Y1) and (X+X2, Y+Y1+[X2-X1])
;in a color of COLOR
;X, Y are variables (might be 0)
;X1, X2, Y1 are constants
        SAVE_REGS <AX, BX, CX, DX>
        MOV AH, 0Ch   ;draw pixel
        MOV AL, COLOR ;set color
        MOV CX, X
        ADD CX, X1    ;from column X1
        MOV DX, Y
        ADD DX, Y1    ;from row Y1
L1:
        MOV BH, 0     ;page 0
        INT 10h
        INC CX
        DEC DX
        MOV BX, X
        ADD BX, X2    ;to column X2
        INC BX
        CMP CX, BX
        JE DONE
        JMP L1
DONE:
        RESTORE_REGS <DX, CX, BX, AX>
        ENDM
        
DRAW_SQUARE MACRO X, Y, X1, X2, Y1, Y2, COLOR
        LOCAL L1, LOOP1, DONE
;this macro draws a rectangle in a color of COLOR
;whose vertices are at (X+X1, Y+Y1), (X+X1, Y+Y2), (X+X2, Y+Y1), (X+X2, Y+Y2)
;X, Y are variables (might be 0)
;X1, X2, Y1, Y2, are constants
        SAVE_REGS <AX, BX, CX, DX>
;draw a line in row Y, from column X1 to X2
        MOV AH, 0Ch   ;draw pixel
        MOV AL, COLOR ;set color
        MOV CX, X
        ADD CX, X1    ;from column X1
        MOV DX, Y
        ADD DX, Y1    ;from row Y1
LOOP1:
        MOV BH, 0     ;page 0
        INT 10h
        INC CX        ;go to the next column
        MOV BX, X
        ADD BX, X2    ;until column X2
        INC BX
        CMP CX, BX    ;beyond column X2?
        JB L1         ;no, repeat
        MOV CX, X
        ADD CX, X1    ;yes, go to the next row at column X1
        INC DX        ;go to the next row
        MOV BX, Y
        ADD BX, Y2    ;until row Y2
        INC BX
        CMP DX, BX    ;beyond row Y2?
        JE DONE       ;yes, done
L1:
        JMP LOOP1     ;no, loop back
DONE:
        RESTORE_REGS <DX, CX, BX, AX>
        ENDM
