
;************************************************************************
; Terminate and stay resident program to intercept INT 5, caused by     *
; <Shift>+<PrtSc>, and to save graphics screen into a file.             *
;************************************************************************


;_TEXT     SEGMENT BYTE PUBLIC 'CODE'
;          ASSUME  CS:_TEXT,DS:_TEXT
;          ASSUME  ES:_TEXT,SS:_TEXT

;         ORG   100H
          JMP   Init_Dump

        ;*****************************************************
        ; This is where we get when the <Shift>+<PrtSc> is detected
        ;*****************************************************

Print_Int       PROC FAR
        STI
        PUSH    AX                      ;Save registers
        PUSH    BX
        PUSH    CX
        PUSH    DX

        CALL    _Screen_Dump            ;Call routine to save video buffer

        POP     DX                      ;Restore registers
        POP     CX
        POP     BX
        POP     AX
        IRET
Print_Int       ENDP

        ;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        ;INSERT THE SCREEN_DUMP ROUTINE HERE
        ;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
Last_Byte:
        ;***************************************************************
        ; THIS IS THE INITIALIZATION DONE ONLY WHEN LOADED INTO MEMORY
        ;***************************************************************

Message   DB    "Screen Dump Utility Loaded",0Ah,0Dh,0

Init_Dump:

        ;--- Print a message telling user that we are installed

        PUSH    CS                      ;Fetch pointer to sign on message
        POP     DS
        LEA     SI,Message
        MOV     BH,0                    ;Use BIOS to print the message
        MOV     BL,7
        LODSB                           ;Fetch first character of message
Write:  MOV     AH,0EH                  ;Output the next character
        INT     10H                     ;using BIOS function E
        LODSB                           ;Fetch next character of the message
        CMP     AL,0                    ;Is it the terminating zero?
        JNZ     WRITE                   ;...No, go output next one

        ;--- Use DOS services to revector Interrupt 5

        MOV     BX,CS                   ;Use service 25 to set vector 5
        MOV     DS,BX
        MOV     DX,OFFSET Print_Int
        MOV     AL,05H
        MOV     AH,25H
        INT     21H

        ;Terminate but stay resident

        MOV     BX,CS                   ;Use DOS service 31 to leave us residen
        MOV     DS,BX
        MOV     DX,OFFSET Last_Byte
        SHR     DX,1
        SHR     DX,1
        SHR     DX,1
        SHR     DX,1
        INC     DX
        MOV     AX,3100H
        INT     21H

        RET
;_TEXT   ENDS
;       END
