
;************************************************************************
; Fetch a character at position Row, Column and return its code         *
; Entry: The follwing parameters are passed on the stack as words       *
;                     Row, Col                                          *
; Exit: AX character code                                               *
;************************************************************************

Row     EQU     [BP+4]
Column  EQU     [BP+6]

        PUBLIC _Read_Character

_Read_Character PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    DI                      ;Preserve registers
        PUSH    ES

        ;--- Convert row and column to absolute offset within display buffer

        XOR     AX,AX                   ;Point ES to segment zero
        MOV     ES,AX
        MOV     AX,Row                  ;Fetch row number
        MOV     BX,ES:[BIOS_Columns]    ;Fetch columns per screen
        MUL     BX                      ;Compute absolute address as
        ADD     AX,Column               ; Column + Row * Columns)
        SHL     AX,1                    ; Account for attributes
        MOV     DI,AX                   ;Move address into register DI

        ;--- Determine and load segement of the display buffer

        MOV     AX,0B000H               ;Assume monochrome buffer address
        TEST    BYTE PTR ES:[BIOS_Equipment],2   ;Is mono attached?
        JNZ     Read_Char_Ok            ;...Yes, go load segment
        MOV     AX,0B800H               ;...No, change address to color
Read_Char_Ok:
        MOV     ES,AX                   ;Set segment of display buffer

        ;--- Fetch the character

        MOV     AL,ES:[DI]              ;Get character
        XOR     AH,AH                   ;Clear upper half

        POP     ES                      ;Restore registers
        POP     DI
        MOV     SP,BP
        POP     BP
        RET
_Read_Character ENDP
