
;************************************************************************
; Enable the split screen                                               *
; Enter:        Split   - Scan line for the split                       *
; Works only for 'standard' EGA modes                                   *
;************************************************************************

Split           EQU     [BP+4]

        PUBLIC  _Split_Screen

_Split_Screen   PROC    NEAR
        PUSH    BP                      ;Setup pointer to parameters
        MOV     BP,SP
        CALL    _Vertical_Retrace       ;Wait for vertical retrace
        PUSH    ES                      ;Get pointer to BIOS data area
        XOR     AX,AX
        MOV     ES,AX
        MOV     DX,3B4H                 ;Assume CRTC address is mono address
        TEST    BYTE PTR ES:[BIOS_Equipment],2   ;Is mono display attached?
        JNZ     SS_CRT_Ok               ;...Yes, keep DX as is
        MOV     DX,3D4H                 ;...No, change DX to 3D4
SS_CRT_Ok:
        MOV     AL,18H                  ;Get index for LINE COMPARE register
        OUT     DX,AL                   ;Select register
        INC     DX
        MOV     AX,Split                ;Get split line bits 0-7
        OUT     DX,AL                   ;Set LINE COMPARE register
        DEC     DX

        ; Split bits beyond 7 (8 and maybe 9) are handeled differently
        ; for EGA and VGA.  Here we decide which case to handle

        CALL    _Get_Scanlines          ;If we have up to 480 lines
        CMP     AX,480                  ;then can do VGA processing
        JL      EGA_Split               ;...otherwise do EGA processing
VGA_Split:
        MOV     AL,7                    ;Select OVERFLOW register
        OUT     DX,AL
        INC     DX
        IN      AL,DX                   ;Get current overflow value
        MOV     BL,Split+1              ;Fetch bit 8 from split
        AND     BL,1
        MOV     CL,4
        SHL     BL,CL
        AND     AL,NOT 10H              ;Clear bit in data just read in
        OR      AL,BL                   ;Add the bit 8 from split
        OUT     DX,AL                   ;Write to new value to OVERFLOW reg
        DEC     DX
        MOV     AL,9                    ;Get MAX SCAN LINE register value
        OUT     DX,AL
        INC     DX
        IN      AL,DX
        AND     AL,NOT 40H              ;Clear bit (since split bit 9 is 0)
        OUT     DX,AL                   ;Set the new value
        JMP     Split_Done
EGA_Split:
        MOV     BL,Split+1              ;Fetch split bit 8 for overflow reg
        AND     BL,1
        MOV     CL,4                    ;Shift bit 8 into proper position
        SHL     BL,CL
        CMP     DX,3B4H                 ;Monochrome mode?
        JE      display_350             ;...Yes,350 line mode
        MOV     AL,ES:[BIOS_Switch]     ;Get display type from
        CMP     AL,3                    ;switch setting
        JE      Display_350             ;Enhanced display?
        CMP     AL,9                    ;...Yes, 350 line mode
        JE      Display_350
Display_200:                            ;...No, use 200 line mode
        OR      BL,01H                  ;Get 200 line value
        JMP     Over_Set
Display_350:
        OR      BL,0FH                  ;Get 350 line value
Over_Set:
        MOV     AL,07H                  ;Select overflow register
        OUT     DX,AL
        INC     DX                      ;Fetch address of overflow register
        MOV     AL,BL                   ;Fetch value for overflow register
        OUT     DX,AL                   ;Set Overflow register
Split_Done:
        POP     ES                      ;Restore ES and return
        POP     BP
        RET
_Split_Screen   ENDP
