
;************************************************************************
; Read first character generator from plane 2                           *
; Entry:        DS:Buffer       - Pointer to buffer where to store      *
;                                 32x256 bytes of data                  *
; Exit:         It is assumed that the adapter is in one of the text    *
;               modes 0,1,2,3 or 7 otherwise state is unpredictable     *
;               and will have to be reset by the calling procedure      *
;************************************************************************

Buffer  EQU     [BP+4]

        PUBLIC  _Read_Char_Gen

_Read_Char_Gen  PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    ES
        PUSH    DS
        PUSH    DI
        PUSH    SI

        ;--- Enable for read

        MOV     DX,3C4H                 ;Disable even/odd and text mode
        MOV     AL,4
        OUT     DX,AL
        INC     DX
        MOV     AL,6
        OUT     DX,AL

        MOV     DX,3CEH                 ;Select plane 2 for read
        MOV     AL,4
        OUT     DX,AL
        MOV     AL,2
        INC     DX
        OUT     DX,AL
        DEC     DX

        MOV     AL,5                    ;Disable odd/even & color compare
        OUT     DX,AL
        INC     DX
        MOV     AL,0
        OUT     DX,AL

        DEC     DX                      ;Map plane to start at A000
        MOV     AL,6
        OUT     DX,AL
        INC     DX
        MOV     AL,05H
        OUT     DX,AL

        ;--- Copy character generator into buffer

        MOV     AX,DS                   ;Point ES:DI to buffer
        MOV     ES,AX
        MOV     DI,Buffer
        MOV     AX,0A000H               ;Point DS:SI to char generator
        MOV     DS,AX
        XOR     SI,SI
        MOV     CX,32*256               ;Number of bytes to move
        REP     MOVSB                   ;Copy the data

        ;--- Restore mode

        MOV     DX,3C4H                 ;Enable even/odd and text mode
        MOV     AL,4
        OUT     DX,AL
        INC     DX
        MOV     AL,3
        OUT     DX,AL

        MOV     DX,3CEH                 ;Restore plane 0 for read
        MOV     AL,4
        OUT     DX,AL
        MOV     AL,0
        INC     DX
        OUT     DX,AL
        DEC     DX

        MOV     AL,5                    ;Restore odd/even
        OUT     DX,AL
        INC     DX
        MOV     AL,10H
        OUT     DX,AL

        XOR     AX,AX
        MOV     ES,AX
        TEST    BYTE PTR ES:[BIOS_Equipment],2
        JNZ     Set_B000

        MOV     DX,3CEH                 ;Map display buffer to B800
        MOV     AL,6
        OUT     DX,AL
        INC     DX
        MOV     AL,0EH
        OUT     DX,AL
        JMP     RCG_Done
Set_B000:
        MOV     DX,3CEH                 ;Map display buffer to B000
        MOV     AL,6
        OUT     DX,AL
        INC     DX
        MOV     AL,0AH
        OUT     DX,AL
RCG_Done:
        POP     SI
        POP     DI
        POP     DS
        POP     ES
        MOV     SP,BP
        POP     BP
        RET
_Read_Char_Gen  ENDP
