
;************************************************************************
; Write 'Hello' in the middle of the 80x25 screen using                 *
; BIOS function 13hex, and move cursor to the start of next             *
; line by including CARRIAGE RETURN and LINEFEED in the text            *
;************************************************************************

CARRIAGE_RETURN EQU     0DH
LINE_FEED       EQU     0AH

Text            DB      'Hello', CARRIAGE_RETURN, LINE_FEED

        PUBLIC  _BIOS_Write_String

_BIOS_Write_String PROC NEAR
        PUSH    ES                      ;Preserve registers
        PUSH    BP

        MOV     AX,CS                   ;Get pointer to the string
        MOV     ES,AX                   ;into register pair ES:BP
        LEA     BP,Text
        MOV     BX,0                    ;Select page 0
        MOV     BL,7                    ;Use normal attribute
        MOV     CX,5                    ;Display 5 characters
        MOV     DH,12                   ;Start at row 12
        MOV     DL,40                   ;Start at column 40
        MOV     AH,13H                  ;Function = WRITE TEXT STRING
        MOV     AL,0H                   ;Subfunction = Update Cursor Pos.
        INT     10H                     ;Ask BIOS to display the text

        POP     BP
        POP     ES                      ;Restore segment register
        RET
_BIOS_Write_String ENDP
