
;************************************************************************
; Clear memory according to the current mode                            *
;************************************************************************

        PUBLIC  _Clear_Screen

Clear_Table     DW      OFFSET  Clear_Col_Text          ;mode 0
                DW      OFFSET  Clear_Col_Text          ;mode 1
                DW      OFFSET  Clear_Col_Text          ;mode 2
                DW      OFFSET  Clear_Col_Text          ;mode 3
                DW      OFFSET  Clear_One_Plane         ;mode 4
                DW      OFFSET  Clear_One_Plane         ;mode 5
                DW      OFFSET  Clear_One_Plane         ;mode 6
                DW      OFFSET  Clear_Mono_Text         ;mode 7
                DW      OFFSET  Clear_All_Planes        ;mode 8
                DW      OFFSET  Clear_All_Planes        ;mode 9
                DW      OFFSET  Clear_All_Planes        ;mode a
                DW      OFFSET  Clear_All_Planes        ;mode b
                DW      OFFSET  Clear_All_Planes        ;mode c
                DW      OFFSET  Clear_All_Planes        ;mode d
                DW      OFFSET  Clear_All_Planes        ;mode e
                DW      OFFSET  Clear_All_Planes        ;mode f
                DW      OFFSET  Clear_All_Planes        ;mode 10

_Clear_Screen   PROC NEAR
        PUSH    ES
        PUSH    DI

        XOR     AX,AX                   ;Point ES to segment zero
        MOV     ES,AX
        MOV     BL,ES:[BIOS_Mode]       ;Fetch current video mode
        XOR     BH,BH
        CMP     BX,10H
        JA      Clear_Done
        SHL     BX,1
        JMP     Clear_Table[BX]         ;Select clear according to mode

Clear_Mono_Text:                        ;Load constants for mode 7
        MOV     CX,ES:[BIOS_Page_Size]
        MOV     AX,0B000H
        MOV     ES,AX
        MOV     AX,0720H
        JMP     Clear

Clear_Col_Text:                         ;Load constants for modes 0-3
        MOV     CX,ES:[BIOS_Page_Size]
        MOV     AX,0B800H
        MOV     ES,AX
        MOV     AX,0720H
        JMP     Clear

Clear_One_Plane:                        ;Load constants for graphics modes
        MOV     CX,ES:[BIOS_Page_Size]  ;4,5 and 6
        MOV     AX,0B800H
        MOV     ES,AX
        MOV     AX,0
        JMP     Clear

Clear_All_Planes:                       ;Load constanst for all new graphics
        MOV     CX,ES:[BIOS_Page_Size]  ;modes D,E,F,10
        MOV     AX,0A000H
        MOV     ES,AX
        MOV     AX,0
        MOV     DX,3C4H                 ;Address of Sequencer
        MOV     AL,2                    ;Index for PLANE ENABLE register
        OUT     DX,AL                   ;Select register
        INC     DX
        MOV     AL,0FH                  ;Fetch value to enable all 4 planes
        OUT     DX,AL                   ;Set PLANE ENABLE register
        MOV     AX,0
        JMP     Clear

Clear:                                  ;Using pre-loaded constants
        XOR     DI,DI                   ;for segment, count, and value
        REP     STOSW                   ;clear the display memory
Clear_Done:
        POP     DI
        POP     ES
        RET
_Clear_Screen   ENDP
