TITLE GAME3E: RIGHT PADDLE CONTROL

EXTRN  PADDLE_TOP_RIGHT:WORD, PADDLE_BOTTOM_RIGHT:WORD
PUBLIC DRAW_PADDLE_RIGHT, MOVE_PADDLE_RIGHT

.MODEL SMALL
.CODE

DRAW_HAND_COLUMN2 MACRO X
LOCAL TOP
;INPUT: AL = PIXEL VALUE, CX= COLUMN, DX= ROW, X= LENGTH OF COLUMN
;OUTPUT: Draws a horizontal line starting from the given position indicated
;        by CX and DX

        PUSH BX
        MOV AH, 0CH
        MOV BX, X
        XOR BH, BH
TOP:    INT 10H
        INC DX
        DEC BX
        JNZ     TOP
        POP BX
        ENDM

DRAW_PADDLE_RIGHT PROC

        PUSH AX                 ;save registers
        PUSH BX
	PUSH CX
	PUSH DX

;The following lines will draw the hand by incrementing and decrementing
;CX and DX according to a graphical analysis.
;It utilizes the Draw_Hand_Column macro (which takes in the lenght of
;the hand portion to be drawn.

        MOV CX, 299
        MOV DX, PADDLE_TOP_RIGHT 
        PUSH DX          ;FIRST COLUMN
        ADD DX, 3
        DRAW_HAND_COLUMN2 5
        ADD DX, 3
        DRAW_HAND_COLUMN2 5
        POP DX
        PUSH DX
        DEC CX           ;NEXT COLUMN (SECOND COLUMN)
        ADD DX, 3
        DRAW_HAND_COLUMN2 5
        ADD DX, 3
        DRAW_HAND_COLUMN2 5
        POP DX
        PUSH DX
        DEC CX           ;NEXT COLUMN (THIRD COLUMN)
        ADD DX, 2
        DRAW_HAND_COLUMN2 6
        ADD DX, 3
        DRAW_HAND_COLUMN2 6
        POP DX
        PUSH DX
        DEC CX           ;NEXT COLUMN (FOURTH COLUMN)
        DRAW_HAND_COLUMN2 8
        ADD DX, 3
        DRAW_HAND_COLUMN2 8
        POP DX
        PUSH DX
        DEC CX           ;NEXT COLUMN (FIFTH COLUMN)
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 7
        ADD DX, 1
        DRAW_HAND_COLUMN2 7
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        POP DX
        PUSH DX
        DEC CX           ;NEXT COLUMN (SIXTH COLUMN)
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 7
        ADD DX, 1
        DRAW_HAND_COLUMN2 7
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        POP DX
        PUSH DX
        DEC CX           ;NEXT COLUMN (SEVETHTH COLUMN)
        ADD DX,2
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        POP DX
        PUSH DX
        DEC CX           ;NEXT COLUMN (EIGHTH COLUMN)
        ADD DX,2
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1       
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        POP DX
        PUSH DX
        DEC CX           ;NEXT COLUMN (NINTH COLUMN)
        ADD DX,2
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 5
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        ADD DX, 1
        DRAW_HAND_COLUMN2 1
        POP DX
        DEC CX           ;NEXT COLUMN (TENTH COLUMN)
        ADD DX,4
        DRAW_HAND_COLUMN2 1
        ADD DX, 9
        DRAW_HAND_COLUMN2 1
        
        POP DX                          ;restore registers
        POP CX
        POP BX
        POP AX
        RET


DRAW_PADDLE_RIGHT ENDP

		

MOVE_PADDLE_RIGHT PROC
;Input: ax = 2 (to move hand down 2 pixels)
;       ax = -2 (to move hand up 2 pixels)


        MOV BX,AX                       ;copy bx

	CMP AX,0
        JL UP                           ;neg, move up

        CMP PADDLE_BOTTOM_RIGHT,188     ;at bottom?
        JGE DONE                        ;yes, cannot move
	JMP UPDATE

UP:     CMP PADDLE_TOP_RIGHT,11
	JLE DONE

UPDATE:
        MOV AL,0                        ;background color
        CALL DRAW_PADDLE_RIGHT

        ADD PADDLE_TOP_RIGHT,BX
        ADD PADDLE_BOTTOM_RIGHT,BX
        MOV AL,5                         ;color of hand
        CALL DRAW_PADDLE_RIGHT

DONE:   RET

MOVE_PADDLE_RIGHT ENDP

END	
