TITLE GAME3C: KEYBOARD INTERRUPT

EXTRN SCAN_CODE:BYTE, KEY_FLAG:BYTE
PUBLIC KEYBOARD_INT

.MODEL SMALL
.CODE

KEYBOARD_INT PROC
;keyboard interrupt routine
;save registers

        PUSH DS                 ;save ds
        PUSH AX                 ;save ax

        MOV AX,SEG SCAN_CODE    ;set up ds
	MOV DS,AX

;input scan code
        IN AL,60H               ;read scan code
        PUSH AX                 ;save it
        IN AL,61H               ;control port value
        MOV AH,AL               ;save ah
        OR AL,80H               ;set bit for keyboard
        OUT 61H,AL              ;write back
        XCHG AH,AL              ;get back control value
        OUT 61H,AL              ;reset control port
        POP AX                  ;recover scan code
        MOV AH,AL               ;save scan code in ah
        TEST AL,80H             ;test for beak code
        JNE KEY_0               ;yes, clear flags, goto key_0

;make code
        MOV SCAN_CODE,AL        ;save in variable
        MOV KEY_FLAG,1          ;set key flag
KEY_0:  MOV AL,20H              ;reset interrupt
	OUT 20H,AL

;restore register
        POP AX                  ;restore ax
        POP DS                  ;restore ds
	IRET

KEYBOARD_INT ENDP               ;end keyboard routine

END
