TITLE GAME3B: BALL MOVEMENT
;contains move_ball_a and check_boundary_a
EXTRN DISPLAY_BALL:NEAR, BEEP:NEAR, SET_DISPLAY_MODE:NEAR, DRAW_PADDLE_RIGHT:NEAR
EXTRN TIMER_FLAG:BYTE, VEL_X:WORD, VEL_Y:WORD, DRAW_PADDLE:NEAR
PUBLIC MOVE_BALL_A

.MODEL SMALL


DRAW_NEW_COLUMN MACRO 
     LOCAL TOP

	PUSH DX                         ;store dx
	PUSH BX                         ;store bx
	MOV AH, 0CH                     ;draw pixel
	MOV BX, 141                     ;set length equal to 141
TOP:
	INT 10H                         ;draw
	INC DX                          ;move down a row
	DEC BX                          ;keep track of length, reduce by one
	JNZ TOP                         ;finished?, if not repeat
	POP BX                          ;restore bx
	POP DX                          ;restore dx
	ENDM


DRAW_ANGLE_LINE MACRO Z
     LOCAL TOP


	PUSH DX                         ;restore dx
	PUSH CX                         ;restore cx
	PUSH BX                         ;restore bx
	MOV AH, 0CH                     ;draw pixel
	MOV BX, Z                       ;move length of angle line into bx
TOP:
	INT 10H                         ;draw
	INC DX                          ;move down a row
	DEC CX                          ;move over a column
	DEC BX                          ;keep track of length
	CMP BX, 0                       ;finished? line complete
	JNE TOP                         ;if not finish repeat

	POP BX                          ;restore bx
	POP CX                          ;restore cx
	POP DX                          ;restore dx
	ENDM




.CODE

MOVE_BALL_A PROC
;Method:        Erase ball at current position and display 
;               ball at new position.
;input:         cx = column
;               dx = row
;output:        dx = row
;               cx = column
	MOV AL,0                ;color 0 is background color
	CALL DISPLAY_BALL       ;erase ball

	PUSH CX                 ;save cx
	PUSH DX                 ;save dx

;DRAW NET BEGIN:

	MOV CX, 155             ;draw net at column 155
	MOV DX, 11              ;draw net at row 11
	MOV BX, 46              ;draw 
	MOV AL,3


	DRAW_ANGLE_LINE 40      ;draw angle line of length 40

NEW_NET:
	ADD DX, 3               ;move down 3 rows
	DRAW_ANGLE_LINE 17      ;draw angle line of length 17
	DEC BX                  
	CMP BX, 0
	JNZ NEW_NET

	MOV BX, 6               ;number of angle lines in net

	DRAW_ANGLE_LINE 40
	MOV DX, 10
	MOV CX, 155

NET_LINE:
	DRAW_NEW_COLUMN 
	SUB CX, 3
	ADD DX, 3
	DEC BX
	CMP BX, 0
	JNZ NET_LINE


;DRAW NET END

	POP DX
	POP CX


	MOV AL, 5               ;The following few lines redraws the
	CALL DRAW_PADDLE        ;hand since it may have been erased by
	MOV AL, 5               ;the ball's movements.
	CALL DRAW_PADDLE_RIGHT

	ADD CX,VEL_X            ;The ball is moved.
	ADD DX,VEL_Y            

	CALL CHECK_BOUNDARY_A



TEST_TIMER_1:
	CMP TIMER_FLAG,1        ;timer ticked?
	JNE TEST_TIMER_1        ;no, keep testing
	MOV TIMER_FLAG,0        ;yes, clarify
	MOV AL,3                ;white color
	CALL DISPLAY_BALL       ;show ball
			
	ret

	
MOVE_BALL_A ENDP        


CHECK_BOUNDARY_A PROC

;Input:  CX and DX are the location of where the ball is located (actually
;        its just the starting position of where the ball is to be drawn).
;Output: VEL_X, VEL_Y are updated according to whether they hit the
;        walls or not (or even the net).
;Method: Check boundaries and if they are equal to CX or DX, then
;        update the direction of the ball.

HIT_NET:
	CMP DX, 170             ;net doesn't exist below row 170
	JG KEEP
	CMP CX, 154             ;net begins to exist here to
	JG KEEP
	CMP CX,147              ;here.
	JL KEEP
OKAY:
	MOV AX, 5               ;set up for the random procedure. (18% chance)
	INT 62H                 ;Call random.
	CMP AX, 1               ;check if there is a chance that it hit the net.
	JNE KEEP
	NEG VEL_X               ;if it hit, turn the ball around back to the hitter!
	CALL BEEP
	JMP KEEP

KEEP: 
	CMP CX,12               ;checks the left wall
	JG L1
	MOV CX,12
	NEG VEL_X               ;if it hit, change the direction
	CALL BEEP
	JMP L2

L1:     CMP CX,294              ;check the right wall.
	JL L2
	MOV CX,294
	NEG VEL_X               ;if it hit, change the direction
	CALL BEEP

L2:     CMP DX,14               ;check the top wall.
	JG L3
	MOV DX,14
	NEG VEL_Y               ;if it hit, change the y-direction
	CALL BEEP
	JMP DONE

L3:     CMP DX,185              ;check the bottom wall.
	JL DONE
	MOV DX,184
	NEG VEL_Y               ;if it hit, change the y-direction.
	CALL BEEP
DONE:
	RET

CHECK_BOUNDARY_A ENDP

END
