
;***********************************************************************
; Eable use of attribute to select between two                         *
; 256 character generators                                             *
;***********************************************************************

Gen_A   EQU     0                       ;For now we choose A to be first 256
Gen_B   EQU     1                       ;and B to be second 256 bitmaps

        PUBLIC  _Enable_Second_Set

_Enable_Second_Set PROC    NEAR
        MOV     DX,3C4H                 ;Index for SELECT register
        MOV     AL,3
        OUT     DX,AL
        INC     DX                      ;Output value
        MOV     AL,Gen_B                ;Shift Gen_B into bits 2 and 3
        SHL     AL,1
        SHL     AL,1
        AND     AL,1100B
        MOV     AH,Gen_A
        AND     AH,11B                  ;Shift Gen_A into bits 0 & 1
        OR      AL,AH
        OUT     DX,AL                   ;Output the value
        RET
_Enable_Second_Set ENDP

;************************************************************************
; Force generator to be always the first 256 characters                 *
; in plane 2                                                            *
;************************************************************************

        PUBLIC  _Disable_Second_Set

_Disable_Second_Set PROC    NEAR
        MOV     DX,3C4H                 ;Fetch address of SEQUENCER
        MOV     AL,3                    ;Fetch index for CHAR GEN SELECT reg
        OUT     DX,AL                   ;Select index
        INC     DX
        MOV     AL,0                    ;Select value = same for A and B
        OUT     DX,AL                   ;Set register to the value
        RET
_Disable_Second_Set ENDP
