
;************************************************************************
; Set current cursor position by changing CRTC registers                *
; Entry:        Row             - Desired row number                    *
;               Column          - Desired column numer                  *
;************************************************************************

Row     EQU     [BP+4]
Column  EQU     [BP+6]

        PUBLIC  _Set_Cursor_Position

_Set_Cursor_Position PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    ES
        XOR     AX,AX                   ;Point ES to segment 0
        MOV     ES,AX

        ;--- Convert (row,column) to absolute address in display buffer

        MOV     AX,Row                  ;Convert row,column to
        MOV     DX,ES:[BIOS_Columns]    ;absolute address
        MUL     DX
        ADD     AX,Column
        MOV     BX,AX                   ;Save absolute address in BX

        ;--- Write absolute address to CRT CURSOR ADDRESS registers (E & F)

        MOV     DX,ES:[BIOS_CRT_Addr]   ;Load CRTC address
        MOV     AL,0EH                  ;Fetch index of cursor high
        OUT     DX,AL                   ;Select index
        INC     DX                      ;Load CRTC address
        MOV     AL,BH                   ;Fetch data value
        OUT     DX,AL                   ;Write data

        DEC     DX                      ;Load CRTC address
        MOV     AL,0FH                  ;Fetch index of cursor low
        OUT     DX,AL                   ;Select index
        INC     DX                      ;Load CRTC address
        MOV     AL,BH                   ;Fetch data value
        OUT     DX,AL                   ;Write data

        ;--- Update BIOS data area so that BIOS knows about new position

        MOV     AL,Column               ;Update BIOS data area
        MOV     AH,Row
        MOV     ES:[BIOS_Curs_Pos],AX

        POP     ES
        MOV     SP,BP
        POP     BP
        RET
_Set_Cursor_Position ENDP
