
;************************************************************************
; Determine amount of installed EGA memory using constants in segment 0 *
; Exit: AX - Number of KiloBytes installed                              *
;       64  =>  64KBytes                                                *
;       128 => 128KBytes                                                *
;       256 => 256KBytes                                                *
;************************************************************************

        PUBLIC  _Get_Memory_Size

_Get_Memory_Size PROC NEAR
        PUSH    ES                      ;Preserve ES
        XOR     AX,AX                   ;Move segment zero into ES
        MOV     ES,AX
        MOV     AL,ES:[BIOS_Equipment]  ;Fetch info byte
        AND     AX,60H                  ;Isolate bit1 and bit2 and
        MOV     CL,5
        SHR     AX,CL                   ; move it onto bit0 and 1
        INC     AX                      ; map 0-3 into 1-4
        MOV     CL,6                    ;Convert to multiple of 64
        SHL     AX,CL
        POP     ES                      ;Restore ES
        RET
_Get_Memory_Size ENDP
