
;************************************************************************
; Setup text mode with more addressable columns (80 visible)            *
; Entry:        [BP+4] - Number of columns to use (80 - 255)            *
;************************************************************************

        PUBLIC  _Set_More_Columns

_Set_More_Columns  PROC    NEAR
        PUSH    BP                      ;Standard entry from C call
        MOV     BP,SP
        PUSH    ES

        XOR     AX,AX                   ;Get address of CRT controller
        MOV     ES,AX                   ;From segment 0
        MOV     DX,ES:[BIOS_CRT_Addr]
        MOV     AL,13H                  ;Index for OFFSET register
        OUT     DX,AL                   ;Select index
        INC     DX
        MOV     AX,[BP+4]               ;Fetch new text line width
        MOV     ES:[BIOS_Columns],AX    ;Let BIOS know about new width
        SHR     AL,1                    ;Divide by 2 for OFFSET regiser
        OUT     DX,AL                   ;Set OFFSET register

        POP     ES                      ;Standard return to C
        MOV     SP,BP
        POP     BP
        RET
_Set_More_Columns ENDP
