
;************************************************************************
; Write palette registers from a table                                  *
;              Set the palette registers to the values in 'table'.      *
;              The palette registers are contained in the               *
;              first 16 registers of the attribute controller.          *
;              Here the 16 registers are loaded using the values from   *
;              the parameter array.                                     *
;                                                                       *
; Entry:        [BP+4] - Pointer to register table (16 palette regs)    *
;                                                                       *
;************************************************************************

        PUBLIC  _Write_Palette

_Write_Palette  PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    SI
        PUSH    ES

        XOR     AX,AX                   ;Get address of CRT controller
        MOV     ES,AX                   ;From segment 0
        MOV     DX,ES:[BIOS_CRT_Addr]
        ADD     DX,6                    ;Compute address of Attrib Read reg
        IN      AL,DX                   ;Reset Attribute flip-flop

        MOV     SI,[BP+4]               ;Get pointer to the parameter table
        MOV     DX,03C0H                ;Address of Attribute controller
        MOV     CX,16                   ;Number of values to load
        XOR     AH,AH                   ;First index to load

PalLoop:MOV     AL,AH                   ;Fetch next index
        OUT     DX,AL                   ;Select next index
        LODSB                           ;Fetch next value from the table
        OUT     DX,AL                   ;Load register with value
        INC     AH                      ;Update index
        LOOP    PalLoop

        MOV     AL,20H                  ;Must turn controller back ON
        OUT     DX,AL

        POP     ES
        POP     SI
        MOV     SP,BP
        POP     BP
        RET
_Write_Palette  ENDP
