
        PAGE    94,118
        TITLE   PROGA.ASM - Assembly Examples for EGA Programmers Guide
        NAME    PROGA

;************************************************************************
;                                                                       *
;       File:   PROGA.ASM                                               *
;       Author: George Sutty                                            *
;       Date:   March 19, 1988                                          *
;       Description: Assembly procedures with examples for programming  *
;               the EGA/VGA.  These examples are in support of the      *
;               text for the  Programmer's Guide to EGA/VGA book.       *
;                                                                       *
;************************************************************************


_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS

DGROUP  GROUP   CONST, _BSS, _DATA

_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS

_TEXT   SEGMENT BYTE PUBLIC 'CODE'
        ASSUME  DS:DGROUP, CS:_TEXT, SS:DGROUP

;************************************************************************
; Video BIOS Data Area Locations                                        *
;************************************************************************

BIOS_Mode       EQU     449H            ;Location of current mode
BIOS_CRT_Addr   EQU     463H            ;Address of CRT controller
BIOS_Rows       EQU     484H            ;Number of text rows
BIOS_Columns    EQU     44AH            ;Number of text columns
BIOS_Height     EQU     485H            ;Character height
BIOS_Page_Size  EQU     44CH            ;Number of bytes in one page
BIOS_Curs_Mode  EQU     460H            ;Cursor start and end
BIOS_Equipment  EQU     487H            ;Type of equipment in system
BIOS_Switch     EQU     488H            ;Configuration switches
BIOS_Curs_Pos   EQU     450H            ;Current cursor address
BIOS_Curs_Start EQU     460H            ;Current cursor shape
BIOS_Curs_Stop  EQU     461H


;************************************************************************
;************************************************************************
;**** LOW LEVEL REGISTER ACESS EXAMPLES                              ****
;************************************************************************
;************************************************************************


INCLUDE         PROG001.ASM
INCLUDE         PROG002.ASM
INCLUDE         PROG003.ASM
INCLUDE         PROG004.ASM
INCLUDE         PROG005.ASM
INCLUDE         PROG006.ASM
INCLUDE         PROG007.ASM
INCLUDE         PROG008.ASM
INCLUDE         PROG009.ASM

;************************************************************************
; Wait for start of next horizontal retrace                             *
;************************************************************************

        PUBLIC  _Horizontal_Retrace

_Horizontal_Retrace     PROC NEAR
        PUSH    ES
        XOR     AX,AX                   ;Get address of STATUS register
        MOV     ES,AX                   ;From segment 0
        MOV     DX,3BAH                 ;Assume monochrome addressing
        TEST    BYTE PTR ES:[BIOS_Equipment],2  ;Is mono display attached?
        JNZ     HR_Address_Ok           ;...Yes, address is ok
        MOV     DX,3DAH                 ;...No, must set color addressing
HR_Address_Ok:

        IN      AL,DX                   ;Read in status
        JMP     $+2
        TEST    AL,01H                  ;Is retrace ON? (if ON, bit = 1)
        JZ      Wait_For_HOn            ;...no, go wait for start
Wait_For_HOff:                          ;...yes, wait for last one to go OFF
        IN      AL,DX
        JMP     $+2
        TEST    AL,01H                  ;Is retrace OFF?
        JNZ     Wait_For_HOff           ;...No, keep waiting
Wait_For_HOn:
        IN      AL,DX
        JMP     $+2
        TEST    AL,01H                  ;Is retrace ON?
        JZ      Wait_For_HOn            ;...No, keep on waiting
        POP     ES
        RET
_Horizontal_Retrace     ENDP

INCLUDE         PROG010.ASM
INCLUDE         PROG012.ASM
INCLUDE         PROG013.ASM
INCLUDE         PROG014.ASM
INCLUDE         PROG071.ASM
INCLUDE         PROG015.ASM
INCLUDE         PROG016.ASM
INCLUDE         PROG017.ASM
INCLUDE         PROG018.ASM

;************************************************************************
;************************************************************************
;**** GETTING INFORMATION EXAMPLES                                   ****
;************************************************************************
;************************************************************************

INCLUDE         PROG020.ASM
INCLUDE         PROG021.ASM
INCLUDE         PROG022.ASM
INCLUDE         PROG023.ASM
INCLUDE         PROG024.ASM
INCLUDE         PROG025.ASM
INCLUDE         PROG026.ASM
INCLUDE         PROG027.ASM
INCLUDE         PROG028.ASM
INCLUDE         PROG029.ASM
INCLUDE         PROG030.ASM
INCLUDE         PROG031.ASM
INCLUDE         PROG032.ASM

;************************************************************************
;************************************************************************
;**** TEXT MODES EXAMPLES                                            ****
;************************************************************************
;************************************************************************


INCLUDE         PROG040.ASM
INCLUDE         PROG041.ASM
INCLUDE         PROG042.ASM
INCLUDE         PROG043.ASM
INCLUDE         PROG044.ASM
INCLUDE         PROG045.ASM
;INCLUDE         PROG023.ASM
;INCLUDE         PROG024.ASM
INCLUDE         PROG046.ASM
INCLUDE         PROG047.ASM
INCLUDE         PROG048.ASM
INCLUDE         PROG049.ASM

INCLUDE         PROG050.ASM
INCLUDE         PROG051.ASM
INCLUDE         PROG052.ASM
INCLUDE         PROG053.ASM
INCLUDE         PROG054.ASM
INCLUDE         PROG055.ASM
INCLUDE         PROG056.ASM
INCLUDE         PROG057.ASM
INCLUDE         PROG058.ASM
INCLUDE         PROG059.ASM

INCLUDE         PROG060.ASM
INCLUDE         PROG061.ASM
INCLUDE         PROG062.ASM
INCLUDE         PROG063.ASM
INCLUDE         PROG064.ASM
INCLUDE         PROG065.ASM
INCLUDE         PROG066.ASM
INCLUDE         PROG067.ASM
INCLUDE         PROG068.ASM
INCLUDE         PROG069.ASM

INCLUDE         PROG070.ASM

;************************************************************************
;************************************************************************
;**** GRAPHICS MODES EXAMPLES                                        ****
;************************************************************************
;************************************************************************

INCLUDE         PROG080.ASM
INCLUDE         PROG081.ASM
INCLUDE         PROG082.ASM
INCLUDE         PROG083.ASM
INCLUDE         PROG084.ASM
INCLUDE         PROG085.ASM
INCLUDE         PROG086.ASM
INCLUDE         PROG087.ASM
INCLUDE         PROG088.ASM
INCLUDE         PROG089.ASM

INCLUDE         PROG090.ASM
INCLUDE         PROG091.ASM

;************************************************************************
; ticks  : Return current value of clock tick                           *
;          which is updated 18.2 times a second                         *
; exit:    Register pair DX,AX will have the 32bit  value suitable      *
;          for return of long integer for MS C compiler.                *
;************************************************************************

        PUBLIC  _TICKS

_TICKS  PROC    NEAR
        PUSH    ES                      ; Point ES to segment zero
        XOR     AX,AX
        MOV     ES,AX
        MOV     AX,ES:[46CH]            ; Fetch the current tick value
        MOV     DX,ES:[46EH]
        POP     ES
        RET
_TICKS  ENDP

_TEXT    ENDS
         END

