; v22.0201, fall 97, Yap
title tick1.asm 
; extension of tick.asm (from p.344 of text, pgm16_2b)
; timer interrupt routine 
; ACTION: 
;	- time is divided into ``phases''
;	- start of phase is indicated by timer_flag turning from 0 to 1
;	- timer_count is initialized to 0 at start of phase
;	- If this is not start of phase, then we increment timer_count
; INVARIANT: timer_flag is always 1 after calling this routine
	PUBLIC timer_tick, timer_flag, timer_count
.model small
.data
timer_flag db 0
timer_count dw 0
.code
; 
timer_tick proc
        push ds
        push ax
        mov ax,seg timer_flag
        mov ds,ax
	;
	  cmp timer_flag,0
	  je timer_begin
	  inc timer_count
	  jmp timer_end
	timer_begin:
        mov timer_flag,1
	  mov timer_count,0
	timer_end:
        pop ax
        pop ds
        iret
timer_tick endp
        end
