title mse_int1.asm: Editor with Mouse
; variant of mse_int.asm
; BUGS: 
;	--DOES NOT WORK UNDER winNT?
;	--did not reset the old mouse routines upon exit.
; To assemble: tasm mse_int+video+mouse
;
; Illustrates the use of setting up mouse interrupts.
;	In this case, we set up a left (button) press and
;	left release interrupt routines.  All that it does
;	is to print the current clock tick for a left press
;	or a left release event.
;
;
; EXTERNAL PROCS
extrn set_mode:near
extrn mse_init:near
if1
	include ..\mac\basic.mac
endif
.model small
.stack 200h
.data
	x	dw 0
	press_x dw ?	; start of select position
	press_y dw ?
	release_x dw ?	; end of select position
	release_y dw ?
	
	no_presses dw 0
	tick0	dw ?	; time of first press
	tick1	dw ?	; time of second press
	tick2	dw ?	; time of second release
	old_Lbut_msk dw ?	; old left button mask
 	old_Lbut_es dw ?	; old left button es
	old_Lbut_dx dw ?	; old left button dx
	.code
main proc
  initdata	;macro
  mov al,12h	;mode 12h
  call set_mode
  call mse_init
 ; 
  call set_mse_int
pause 'contd?'
  ;
  mov al,03h	;mode 3
  call set_mode ; restore mode
  exitdos	;macro
main endp

;******************************************
; set_mse_int
;
;******************************************
set_mse_int proc
  mov ax,seg int_Lbut	; es:dx=use left press+release routine
  mov es,ax
  mov dx,offset int_Lbut 
  xor ch,ch		; cx=mask
  mov cl,00000110b	; left press and release events
  mov ax,14h		; fn=swap interrupt subroutines
  int 33h
  mov old_Lbut_msk,cx	; save old left press mask
  mov ax,es
  mov old_Lbut_es,ax	; save old es
  mov old_Lbut_dx,dx	; save old dx
  ret
set_mse_int endp

;******************************************
; int_Lbut 
; 	set up as mouse interrupt routine
;	INPUT: 	ax=condition mask causing call
;		cx:dx = hor:ver cursor position
;		di:si = hor:ver counts
;		ds = mouse driver data segment
;		bx = button state (bit 0 set= left button pressed)
;				  (bit 1 set= right button pressed)
;******************************************
int_Lbut proc
	save <ax,bx,cx,dx>
	mov ah,0	; fn=read system clock counter
	int 1ah		; real time clock int
	newline
	test bx,1
	jnz _lpressed
	display_it 'Lrelease ticks, (cx,dx)='
	jmp _lbut_out
  _lpressed:
	display_it 'Lpress ticks, (cx,dx)='
  _lbut_out:
	outhex2 cx
	display_it ','
	outhex2 dx
	restore <dx,cx,bx,ax>
	iret
int_Lbut endp

;******************************************
; int_Lrelease
;
;******************************************
int_Lrelease proc
	save <ax,bx,cx,dx>
	mov ah,0	; fn=read system clock counter
	int 1ah		; real time clock int
	newline
	display_it 'Lrelease ticks, (cx,dx)='
	outhex2 cx
	display_it ','
	outhex2 dx
	restore <dx,cx,bx,ax>
	iret
int_Lrelease endp

end main
