title c2.asm
; click2: to detect double clicks.
;
; EXTERNAL PROCS
extrn set_mode:near
extrn mse_init:near
if1
	include ..\mac\basic.mac
endif
.model small
.stack 200h
.data
	x	dw 0
	press_x dw ?	; start of select position
	press_y dw ?
	release_x dw ?	; end of select position
	release_y dw ?
	
	no_presses dw 0
	tick0	dw ?	; time of first press
	tick1	dw ?	; time of second press
	tick2	dw ?	; time of second release
	old_Lpress_msk dw ?	; old left press mask
 	old_Lpress_es dw ?	; old left press es
	old_Lpress_dx dw ?	; old left press dx
	old_Lrelease_msk dw ?	; old left release mask
 	old_Lrelease_es dw ?	; old left release es
	old_Lrelease_dx dw ?	; old left release dx
.code
main proc
  initdata	;macro
  mov al,12h	;mode 12h
  call set_mode
  call mse_init
 ; 
  call set_mse_int
pause 'contd?'
  ;
  mov al,03h	;mode 3
  call set_mode ; restore mode
  exitdos	;macro
main endp

;******************************************
; set_mse_int
;
;******************************************
set_mse_int proc
  mov ax,seg int_Lpress	; es:dx=use left press routine
  mov es,ax
  mov dx,offset int_Lpress 
  xor ch,ch		; cx=mask
  mov cl,00000010b	; left press and release events
  mov ax,14h		; fn=swap interrupt subroutines
  int 33h
  mov old_Lpress_msk,cx	; save old left press mask
  mov ax,es
  mov old_Lpress_es,ax	; save old es
  mov old_Lpress_dx,dx	; save old dx
  ;
  mov ax,seg int_Lrelease	; es:dx=use left release routine
  mov es,ax
  mov dx,offset int_Lrelease 
  xor ch,ch		; cx=mask
  mov cl,00000100b	; left release event
  mov ax,14h		; fn=swap interrupt subroutines
  int 33h
  mov old_Lrelease_msk,cx	; save old left release mask
  mov ax,es
  mov old_Lrelease_es,ax	; save old es
  mov old_Lrelease_dx,dx	; save old dx
  ret
set_mse_int endp

;******************************************
; int_Lpress
;
;******************************************
int_Lpress proc
	save <ax,bx,cx,dx>
	mov ah,0	; fn=read system clock counter
	int 1ah		; real time clock int
	newline
	display_it 'Lpress ticks, (cx,dx)='
	outhex2 cx
	display_it ','
	outhex2 dx
	restore <dx,cx,bx,ax>
	iret
int_Lpress endp

;******************************************
; int_Lrelease
;
;******************************************
int_Lrelease proc
	save <ax,bx,cx,dx>
	mov ah,0	; fn=read system clock counter
	int 1ah		; real time clock int
	newline
	display_it 'Lrelease ticks, (cx,dx)='
	outhex2 cx
	display_it ','
	outhex2 dx
	restore <dx,cx,bx,ax>
	iret
int_Lrelease endp

end main
