comment+
	To create a bit mask in AH from a given bit
	pattern in AL.  The mask has 0's followed by
	1's.  The first 1 occurs in the same position
	as the first 1 in AL.
	E.g. AL=00010110  => AH=00011111

	Note: this is a subproblem towards solving
	Dewar's challenge.  We discussed this in lectures.
	It is useful for understanding how the SHIFT or ROTATE
	functions.  You can see how this program works
	by tracing this using the turbo debugger.
	+
title mask create
.model small
.stack 100h
.code
start:
;
; init
mov ax,@data
mov ds,ax
;
; input byte
mov al,00010110b ; initial bit pattern in AL (put anything here)
;
; make mask
mov cx,8        ; loop 8 times
xor ah,ah       ; clear the mask AH
xor dx,dx       ; clear DL,DH  (lsb of DH is called "SeenFlag")
clc             ; clear carry bit
again: 
rol al,1        ; current A-bit is in carry flag
rcl dl,1        ; lsb of DL is current A-bit
or  dh,dl       ; update "SeenFlag" with current A-bit
ror dh,1        ; "SeenFlag" is now duplicated in carry flag
rcl ah,1        ; move the "SeenFlag into AH, to build up the mask
xor dl,dl       ; clear DL for next loop
rol dh,1        ; put back "SeenFlag" in the proper place in DH 
loop again
;
nop		; null operation!  Place a breakpoint here...
;
mov ax,4c00h
int 21h
end start
