COMMENT *
  procedure ENEMY_ACT
  HOW: checks the distance between player and opponent; depending upon
       this distance, selects one of three arrays to use:
         FIERCE = lots of attacks, advances, less defense (6-10,26-30)
         TIMID  = lots of defense and retreats, few attacks (0-5,21-25)
         NORMAL = equal number of attacks and retreats (11-20)
       and uses the RANDOM procedure to place SI at FIERCE[RANDOM#]
       the location of the pointer is saved in global variable AI_PTR
       next time, it still checks the distance between player and opp.
       it then checks if AI_PTR is empty ('E') and if not, incs
       SI and goes to the next one.  if it reaches the end of the array,
       it calls the SELECT section again.
END COMMENT *

POSVAL  DW  0

ENEMYACT        PROC

        PUSH    AX              ; save registers
        PUSH    BX
        PUSH    CX
        PUSH    SI

        CALL   CLEARACTS

        MOV     AX,8
        INT     62h
        MOV     POSVAL,AX

; numbers correspond to actions from the opponent:
; 0 = do nothing                5 = retreat
; 1 = advance                   6 = parry high
; 2 = strike high               7 = parry mid
; 3 = strike mid                8 = parry low
; 4 = strike low                9 = end of file


        CMP     POSVAL,1               ; advance?
        JNE     T_2                    ; if not goto next
        CMP     HISPOS,4           ; at end of strip?
        JL      MEND2P                   ; ignore if so.
        CMP     DISTANCE,5              ; running into him?
        JLE     MEND2P                   ; then do nothing.
        CALL    HCLEAROLD               ; clear the old one
        CALL    HISWALK                 ; make him walk a step
        SUB     HISPOS ,1               ; move one space back
        MOV     AL,FENCOLOR             ; draw a new one
        CALL    DRAWHIM
        JMP     MEND2P                   ; and check timer flag.
T_2:    CMP     POSVAL,5            ; retreat?
        JNE     T_3                    ; if not, goto next
        CMP     HISPOS,27              ; at other end of strip?
        JG      MEND2P                   ; ignore key if so.
        CALL    HCLEAROLD               ; clear the old one
        CALL    HISWALK
        ADD     HISPOS ,1               ; else add one (move one space)
        MOV     AL,FENCOLOR             ; draw a new one
        CALL    DRAWHIM
        JMP     MEND2P                   ; and check timer flag.

T_3:    CMP     POSVAL,2         ; high strike?
        JNE     T_4                     ; if not, goto next
        CALL    HCLEAROLD
        MOV     HISINFO[4],1             ; set strike to high
        MOV     HISINFO[6],2             ; set to graphic 2
        MOV     AL,FENCOLOR
        XOR     AH,AH
        CALL    DRAWHIM
        JMP     MEND2P                   ; and check timer flag.

MEND2P: JMP     END2P

T_4:    CMP     POSVAL,3        ; mid strike?
        JNE     T_5                     ; if not, goto next
        CALL    HCLEAROLD
        MOV     HISINFO[4],2            ; set strike to medium
        MOV     HISINFO[6],3            ; set to graphic 3
        MOV     AL,FENCOLOR
        CALL    DRAWHIM
        JMP     END2P                   ; and check timer flag.

T_5:    CMP     POSVAL,4        ; low strike?
        JNE     T_6                     ; if not, goto next
        CALL    HCLEAROLD
        MOV     HISINFO[4],3              ; set strike to low
        MOV     HISINFO[6],4              ; set to graphic 4
        MOV     AL,FENCOLOR
        CALL    DRAWHIM
        JMP     END2P                   ; and check timer flag.

T_6:    CMP     POSVAL,6                ; high guard? 
        JNE     T_7                     ; if not, goto next
        CALL    HCLEAROLD
        MOV     HISINFO[3],1              ; set guard to high
        MOV     HISINFO[6],5              ; set to graphic 5
        MOV     AL,FENCOLOR
        CALL    DRAWHIM
        JMP     END2P                   ; and check timer flag.

T_7:    CMP     POSVAL,7                ; mid guard?
        JNE     T_8
        CALL    HCLEAROLD
        MOV     HISINFO[3],2              ; set guard to medium
        MOV     HISINFO[6],6              ; set to graphic 6
        MOV     AL,FENCOLOR
        CALL    DRAWHIM
        JMP     END2P                   ; and check timer flag.

T_8:    CMP     POSVAL,8               ; low guard?
        JNE     END2P                   ; if not, goto timer flag
        CALL    HCLEAROLD
        MOV     HISINFO[3],3              ; set guard to low
        MOV     HISINFO[6],7              ; set to graphic 7
        MOV     AL,FENCOLOR
        CALL    DRAWHIM

END2P:

        CALL   DELAY                   ; put in a delay
        POP     SI                     ; restore registers
        POP     CX
        POP     BX
        POP     AX
        RET
ENEMYACT        ENDP

COMMENT * Procedure CLEARACTS: called by the ENEMYACT procedure to clear
          the parry/strike nodes in the HISINFO array to remove his last
          action.
          INPUT: none
          OUTPUT: alteration in HISINFO
END COMMENT *
CLEARACTS       PROC
        MOV     HISINFO[3],0
        MOV     HISINFO[4],0
        RET
CLEARACTS       ENDP
