EXTRN  BLUE:byte, GREEN:byte, CYAN:byte, RED:byte, PURPLE:byte
EXTRN  BROWN:byte, WHITE:byte, GRAY:byte
EXTRN  LIGHT_BLUE:byte, LIGHT_GREEN:byte, LIGHT_CYAN:byte, LIGHT_RED:byte,
EXTRN  LIGHT_MAGENTA:byte, YELLOW:byte,  INT_WHITE:byte

EXTRN  buildings                        ; Array that keeps X-coordinates
                                        ; of buildings.
EXTRN  n_buildings:byte                 ; Number of buildings is to be
                                        ; entered by user

PUBLIC GetReady
        .MODEL  SMALL
;-----------------------------------------------------------------------
INCLUDE GRAPHS.LIB           ; Includes file with graph-mode macros
INCLUDE IMAGES.LIB           ; Includes the routines that will draw
                             ; the images.
INCLUDE MY_MACRO.LIB
;------DATA SEGMENT----------------------------------------------------
        .DATA
        g_title DB      'PREDATOR $'      ; Title string
        s_bs    DB      'Buildings :  $'   ; Show original number of build.-s
        s_ps    DB      'Score :  $'      ; Show original number of planes      
        distance        DB      0         ; Distance between two buildings              
;-----------------------------------------------------------------------
        .CODE
GETREADY    PROC  
        push    ax                       ; Save 
        push    bx                       ;      registers
        push    cx                       ;        that
        push    dx                       ;           will be 
        push    ds                       ;                 used
        push    di                       ;            in the
        push    si                       ;      procedure

        mov     ax,@data                 ; Initialize data segment
        mov     ds,ax

       set_screen_mode       12h
       set_back_color        LIGHT_BLUE

Call    Set_Title                        ; Go set title
Call    Set_Ground                       ; Drawing the ground-line
Call    Set_Buildings                    ; Calling procedure that
                                         ; sets all the buldilngs.

;Setting the gun and the plane on their initial positions

draw_gun  50,400,INT_WHITE,GREEN,BROWN,0
draw_plane 10,50,LIGHT_RED,YELLOW,LIGHT_GREEN,0     
                                               
        pop     si                      ; Restoring registers
        pop     di                      ;
        pop     ds                      ;
        pop     dx                      ;
        pop     cx                      ;
        pop     bx                      ;
        pop     ax                      ;
        ret                             ; return to main module
GETREADY    ENDP                        ; End of GETREADY procedure
;-----------------------------------------------------------------------
Set_Title       PROC
        push    ax
        push    bx
        push    cx
        push    dx                      ; Save registers
        push    di
        push    si

         move_cursor    1,31,0
         print_string   g_title         ; Set Title

         move_cursor    1,1,0           ; Set number of buildings
         print_string   s_bs

         move_cursor    1,61,0          ; Set number of planes
         print_string   s_ps

        pop    si
        pop    di                       ; Restore registers
        pop    dx
        pop    cx
        pop    bx
        pop    ax

        ret                             ; return to calling procedure.        
ENDP
;-----------------------------------------------------------------------

Set_Ground      PROC
        h_line  0,470,640,BROWN,0               ;  Draw
        h_line  0,471,640,BROWN,0               ;  set of
        h_line  0,472,640,BROWN,0               ;  lines
        h_line  0,473,640,BROWN,0               ;  which
        h_line  0,474,640,BROWN,0               ;  will
        h_line  0,475,640,BROWN,0               ;  create
        h_line  0,476,640,BROWN,0               ;  the
        h_line  0,477,640,BROWN,0               ;  ground-line
        h_line  0,478,640,BROWN,0               ;
        ret
ENDP
;-----------------------------------------------------------------------
Set_Buildings   PROC
        push    ax
        push    bx
        push    cx
        push    dx
        push    di
        push    si

        mov     ax,40           ; The length of the base of building = L
        mul     n_buildings     ; AX = L * number of buildings

        mov     cx,640          ; Whole screen
        sub     cx,ax           ; Calculate what's left for gaps into AX
        mov     ax,cx           ; AX = 640 - 40*N

        xor     bx,bx                   ; Now, calculate
        mov     bl,n_buildings          ;   the gap between any two
        inc     bl                      ;            buildings
        div     bl                      ;  put the result
                                        ;  into
        mov     distance,al             ;  variable DISTANCE

        mov     cx,1                    ; Set the buildings cycle begins
Label_set_buildings:
        cmp     cl,n_buildings          ; If all of them have been
        jle     go_on                   ; already set 
        jmp     all_set                 ; then quit
go_on:                                  ; else
        mov     bl,cl                   ;
        dec     bl                      ;  BL = 2 * ( n - 1)
        shl     bl,1                    ;  where n is the number of the
        xor     bh,bh                   ;  building. ( BX is a pointer
                                        ; in buildings array.

        mov     al,distance             ; Put gap between the buildings in AX
        mul     cl                      ; multiply it by the number of the
        mov     dx,ax                   ; building and save in DX.
        dec     cl                      ; Decrease the number of buildings.
        mov     al,40                   ; Put length of the building into AX
        mul     cl                      ; multiply it by the number of
                                        ; the building.
        add     dx,ax                   ; Get X axis coordinate into DX
        inc     cl                      ; Restore CX

mov             word ptr buildings [bx],dx                 ; Save coordinate

draw_building   buildings[bx],466,LIGHT_GREEN,YELLOW,RED,0 ; Set building

        inc     cx                                         ; One more is set!
        jmp     label_set_buildings                        ; Go check
                                                           ; If we are done.
all_set:      ; All the buildings are set, quitting

        pop    ax
        pop    bx
        pop    cx                       ; restoring registers
        pop    dx
        pop    di
        pop    si
        ret
ENDP
;-----------------------------------------------------------------------
        END   
