
;***********************************************************************
; Save current screen into a file PICTURE.001                          *
; Assumes default settings of EGA registers for modes E,F,10           *
;***********************************************************************

Save_Name        DB      'PICTURE.000',0
Save_Handle      DW      0
Save_Counter     DB      0

        PUBLIC  _Screen_Dump

_Screen_Dump    PROC    NEAR
        PUSH    DS                      ;Preserve DS

        ;--- Open next file (*.001 first time, *.002 next,  ...)

        MOV     AX,CS                   ;Setup pointer to file name
        MOV     DS,AX                   ;into DS:DX

        INC     Save_Name[10]           ;Change name so that we can call
                                        ;this routine several times
        LEA     DX,Save_Name
        MOV     CX,0                    ;Normal attribute for the file
        MOV     AH,3CH                  ;DOS function to open file
        INT     21H                     ;Ask DOS to open the file
        JC      Dump_Error              ;Quit on open error
        MOV     Save_Handle,AX          ;Save the handle to the opened file

        ;--- Enable next plane and write the 28,000 bytes into a file

        MOV     Save_Counter,3          ;Initialize counter of planes done
        MOV     DX,3CEH                 ;Select READ MAP SELECT register
        MOV     AL,4                    ;in graphics controller
        OUT     DX,AL
        MOV     AX,0A000H               ;Point DS:DX to display buffer
        MOV     DS,AX
Dump_Plane_Loop:
        MOV     AL,CS:Save_Counter      ;Select next plane for read
        MOV     DX,3CFH
        OUT     DX,AL
        XOR     DX,DX
        MOV     CX,28000                ;Number of bytes to write
        MOV     BX,CS:Save_Handle       ;File handle
        MOV     AH,40H                  ;DOS function to write into a file
        INT     21H                     ;Ask DOS to write data into a file
        JC      Close_Dump_File         ;Quit on error
        CMP     AX,28000
        JNE     Close_Dump_File
        DEC     CS:Save_Counter         ;Check if all planes are done
        JGE     Dump_Plane_Loop ;and if not go do next plane

        ;--- Close the file

Close_Dump_File:
        MOV     BX,CS:Save_Handle       ;Fetch handle
        MOV     AH,3EH                  ;DOS function to close a file
        INT     21H                     ;Ask DOS to close the file
Dump_Done:
        MOV     DX,3CEH                 ;Restore plane 0 for read by
        MOV     AL,3                    ;setting READ MAP register
        OUT     DX,AL                   ;in GRAPHICS controller
        INC     DX
        MOV     AL,0
        OUT     DX,AL

        POP     DS                      ;Restore DS
        RET
Dump_Error:                             ;This is where we can add error
        JMP     Dump_Done               ;reporting
_Screen_Dump    ENDP
