
;************************************************************************
; Prameter and constant definitions                                     *
;************************************************************************

GRAPHICS_CTL    EQU     3CEH            ;Address of Graphics controller
SEQUENCE_CTL    EQU     3C4H            ;Address the Sequencer

XSIZE   EQU     640                     ;Assume 640 pixels across
HBYTES  EQU     (XSIZE/8)               ;Compute bytes per raster
GRAPH_SEG       EQU     0A000H          ;Segment of display buffer

;************************************************************************
; Read value of the pixel at x,y and return value in AX                 *
;************************************************************************

X               EQU     [BP+4]          ;Formal parameters on stack
Y               EQU     [BP+6]

        PUBLIC  _Pixel_Read

_Pixel_Read     PROC    NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    ES
        PUSH    SI

        ; Convert x,y address into OFFSET:SEGMENT and get MASK

        MOV     BX,X                    ;Fetch X coordinate
        MOV     AX,Y                    ;Fetch Y coordinate
        CALL    Get_Address             ;Compute SEGMENT:OFFSET address
                                        ;in ES:BX, Mask in CL

        ; Set MAP MASK register to read next plane and read next plane

        MOV     DX,GRAPHICS_CTL
        MOV     AL,04H                  ;Select MAP MASK register
        OUT     DX,AL
        INC     DX

        MOV     SI,BX                   ;Copy offset into register SI
        XOR     BH,BH                   ;Clear color
        MOV     BL,CL                   ;Copy mask into register CL
        MOV     CX,4                    ;Initialize loop counter
Read_Plane_Loop:
        SHL     BH,1
        MOV     AL,CL                   ;Select next plane for read
        DEC     AL
        OUT     DX,AL

        MOV     AH,ES:[SI]              ;Fetch values for 8 pixels in plane 0
        AND     AH,BL                   ;Mask of the bit for our pixel (mask in
        JZ      Zero_Value              ;Put 0 into next color bit
        OR      BH,1                    ;Put 1 into next color bit
Zero_Value:
        LOOP    Read_Plane_Loop

        MOV     AL,BH                   ;Put result into AX
        XOR     AH,AH

        ; Restore segment registers and return

        POP     SI
        POP     ES                      ;Restore registers
        MOV     SP,BP
        POP     BP
        RET
_Pixel_Read     ENDP
