
;************************************************************************
; Draw a box in upper left corner using BIOS function                   *
; WRITE PIXEL                                                           *
;************************************************************************

BIOS_Write_Pix  EQU     0CH

        PUBLIC  _BIOS_Pixel_Write

_BIOS_Pixel_Write PROC    NEAR

        ; We use CX as a pixel counter as well as pixel address
        ; and use DX as a raster counter as well as raster address

        MOV     DX,100                  ;Want to draw 100 rasters
Box_Raster_Loop:                        ;Loop over rasters
        MOV     CX,100                  ;Want to draw 100 pixels across
Box_Pixel_Loop:                         ;Loop over pixels within raster
        MOV     AL,1                    ;Set color to be 1
        MOV     AH,BIOS_Write_Pix       ;Function = WRITE PIXEL
        INT     10H                     ;Ask BIOS to write pixel

        DEC     CX                      ;Update column number
        JGE     Box_Pixel_Loop          ;If not last do it again
        DEC     DX                      ;Update row number
        JGE     Box_Raster_Loop         ;If not last row do it again
        RET
_BIOS_Pixel_Write ENDP
