
;************************************************************************
; Read character code at the cursor position at Row and Col             *
; Entry: Row,Col  Passed on the stack as integers                       *
; Exit:  AX       Character code found                                  *
;************************************************************************

Row     EQU     [BP+4]
Col     EQU     [BP+6]

        PUBLIC  _BIOS_Read_Char

_BIOS_Read_Char PROC NEAR
        PUSH    BP
        MOV     BP,SP

        MOV     DH,Row                  ;Set row and column
        MOV     DL,Col
        MOV     BH,0                    ;Select page 0
        MOV     AH,2                    ;Function = Set cursor position
        INT     10H                     ;Ask BIOS to set cursor position

        MOV     AH,8                    ;Function = READ CHARACTER & ATTRIBUTE
        MOV     BH,0                    ;from page 0
        INT     10H                     ;Ask BIOS to fetch character

        XOR     AH,AH                   ;Clear upper half of AX

        POP     BP
        RET
_BIOS_Read_Char ENDP
