
;************************************************************************
; Enable text blink by setting Mode Register on EGA                     *
; Entry:        Flag - 0 => disable blinking                            *
;                      1 => enable blinking                             *
;************************************************************************

Flag    EQU     WORD PTR [BP+4]

        PUBLIC  _Text_Blink

_Text_Blink     PROC NEAR
        PUSH    BP
        MOV     BP,SP
        CMP     Flag,0
        JZ      Blink_Off
        CALL    Enable_Blink
        POP     BP
        RET
Blink_Off:
        CALL    Disable_Blink
        POP     BP
        RET
_Text_Blink     ENDP

Enable_Blink    PROC NEAR
        PUSH    ES                      ;Preserve register
        XOR     AX,AX                   ;Point to BIOS data area
        MOV     ES,AX
        TEST    BYTE PTR ES:[BIOS_Equipment],2   ;Is mono display attached?
        JZ      Enable_Color            ;...No, go set color blink
Enable_Mono:
        MOV     DX,3BAH                 ;Get address of Attrib READ register
        IN      AL,DX                   ;Reset data/index flip-flop
        MOV     DX,3C0H                 ;Get address of Attribute controller
        MOV     AL,30H                  ;Select MODE register
        OUT     DX,AL
        MOV     AL,0EH                  ;Enable blink for monochrome text
        OUT     DX,AL
        JMP     Enable_Done
Enable_Color:
        MOV     DX,3DAH                 ;Get address of Attrib READ register
        IN      AL,DX                   ;Reset data/index flip-flop
        MOV     DX,3C0H                 ;Select Mode register
        MOV     AL,30H
        OUT     DX,AL
        MOV     AL,08H                  ;Enable blink for monochrome text
        OUT     DX,AL
Enable_Done:
        POP     ES
        RET
Enable_Blink    ENDP

;************************************************************************
; Disable text blink by setting Mode Register on EGA                    *
;************************************************************************

Disable_Blink   PROC NEAR
        PUSH    ES                      ;Preserve register
        XOR     AX,AX                   ;Point to BIOS data area
        MOV     ES,AX
        TEST    BYTE PTR ES:[BIOS_Equipment],2   ;Is mono display attached?
        JZ      Disable_Color           ;...No, go set color blink
Disable_Mono:
        MOV     DX,3BAH                 ;Get address of Attrib READ register
        IN      AL,DX                   ;Reset data/index flip-flop
        MOV     DX,3C0H                 ;Get address of Attribute controller
        MOV     AL,30H                  ;Select MODE register
        OUT     DX,AL
        MOV     AL,06H                  ;Enable blink for monochrome text
        OUT     DX,AL
        JMP     Disable_Done
Disable_Color:
        MOV     DX,3DAH                 ;Get address of Attrib READ register
        IN      AL,DX                   ;Reset data/index flip-flop
        MOV     DX,3C0H                 ;Select Mode register
        MOV     AL,30H
        OUT     DX,AL
        MOV     AL,00H                  ;Enable blink for monochrome text
        OUT     DX,AL
Disable_Done:
        POP     ES
        RET
Disable_Blink    ENDP
