
;************************************************************************
; Display character Char at position Row, Column (using attributes      *
; already in display buffer)                                            *
; Entry: The follwing parameters are passed on the stack as words       *
;               Char, Row, Col                                          *
;************************************************************************

Char    EQU     [BP+4]
Row     EQU     [BP+6]
Column  EQU     [BP+8]

        PUBLIC _Write_Char

_Write_Char     PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    DI                      ;Preserve registers
        PUSH    ES

        ;--- Convert row and column to absolute offset within display buffer

        XOR     AX,AX                   ;Point ES to segment zero
        MOV     ES,AX
        MOV     AX,Row                  ;Fetch row number
        MOV     BX,ES:[BIOS_Columns]    ;Fetch columns per screen
        MUL     BX                      ;Compute absolute address as
        ADD     AX,Column               ; Column + Row * Columns)
        SHL     AX,1                    ; Account for attributes
        MOV     DI,AX                   ;Move address into register DI

        ;--- Determine and load segement of the display buffer

        MOV     AX,0B000H               ;Assume monochrome buffer address
        TEST    BYTE PTR ES:[BIOS_Equipment],2   ;Is mono attached?
        JNZ     Address_Ok              ;...Yes, go load segment
        MOV     AX,0B800H               ;...No, change address to color
Address_Ok:
        MOV     ES,AX                   ;Set segment of display buffer

        ;--- Save the character

        MOV     AL,Char                 ;Get character
        STOSB                           ;Write it into display buffer

        POP     ES                      ;Restore registers
        POP     DI
        MOV     SP,BP
        POP     BP
        RET
_Write_Char     ENDP
