
;************************************************************************
; Get current size of the cursor from the BIOS data area                *
; Entry: Start - Pointer to where to save the starting value            *
;        Stop  - Pointer to where to save the ending value              *
; Exit:  Values at the pointers are set to proper values                *
;************************************************************************

Start   EQU     [BP+4]
Stop    EQU     [BP+6]

        PUBLIC  _Get_Cursor_Size

_Get_Cursor_Size PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    SI                      ;Preserve SI
        PUSH    ES                      ;Preserve ES
        XOR     AX,AX                   ;Set ES to segment zero
        MOV     ES,AX
        MOV     BX,ES:[BIOS_Curs_Mode]  ;Fetch cursor size
        MOV     SI,Start                ;Fetch pointer to save
        MOV     AL,BH                   ;Fetch start value
        MOV     [SI],AX                 ;Save starting value
        MOV     SI,Stop                 ;Fetch pointer to save
        MOV     AL,BL                   ;Fetch stop value
        MOV     [SI],AX                 ;Save ending value
        POP     ES                      ;Restore segment registers
        POP     SI
        POP     BP
        RET
_Get_Cursor_Size ENDP
