TITLE GAME3A: BEEP

EXTRN TIMER_FLAG:BYTE
PUBLIC BEEP

.MODEL SMALL
.CODE

BEEP PROC
;generate beeping sound
;Method: loads counter (I/O port 42h) with 1193, activates timer, allows
;the beep to last for about 500 ms and deactivates the timer.
;Input: timer_flag
;Output: timer_flag cleared (= 0) and creates a short beep
        PUSH CX                 ;save cx

        MOV AL,0B6H             ;specify mode of operation
        OUT 43H,AL              ;write to port 43h

        MOV AX,1193             ;count for 1000 hz
        OUT 42H,AL              ;low byte
        MOV AL,AH               ;high byte
	OUT 42H,AL
;activate speaker 
        IN AL,61H               ;read control port
        MOV AH,AL               ;save value in ah
        OR AL,11B               ;set control bits
        OUT 61H,AL              ;activate speaker
;500 ms delay loop 
        MOV CX,9                ;do 9 times
B_1:    CMP TIMER_FLAG,1        ;check timer flag
        JNE B_1                 ;not set loop back
        MOV TIMER_FLAG,0        ;flag set, clear it
        LOOP B_1                ;repeat for next tick
;turn off tone
        MOV AL,AH               ;return old control to al
        OUT 61H,AL              ;restore control value
        POP CX                  ;restore cx
	RET

BEEP ENDP

END
