;ChoongHong Oh

TITLE PGM6:ELEVATOR & ARROWS
        EXTRN ELE_TOP : WORD, ELE_BOTTOM : WORD
        EXTRN ARROW1  : WORD, ARROW2 : WORD
        EXTRN BEEP : NEAR
        PUBLIC MOVE_ELE, MOVE_ARROW
        PUBLIC SHOOT_ARROW
.MODEL SMALL

IF1
        INCLUDE G_MACRO.ASM
ENDIF

.CODE
MOVE_ELE PROC 
;this procedure moves elevator up or down, checking if it has reached the top or bottom
;if so, this procedure makes a beep
;input:AX = 15 (to move elevator down by 15 pixels)
;          -15 (to move elevator up by 15 pixels)
        PUSH AX
;check direction
        CMP AX, 0
        JL UP       ;neg, move up
;move down, check elevator position
        CMP ELE_BOTTOM, 377   ;at bottom?
        JL  UPDATE_ELE        ;no, update elevator
        CALL BEEP             ;yes, cannot move and use BEEP to tell user
        JMP DONE_ELE          
;move up, check elevator position
UP:
        CMP ELE_TOP, 180      ;at top?
        JG  UPDATE_ELE        ;no, update elevator
        CALL BEEP             ;yes, cannot move and use BEEP to tell user
        JMP DONE_ELE          
;move elevator
UPDATE_ELE:
        ERASE_ELE
        ADD ELE_TOP, AX
        ADD ELE_BOTTOM, AX
        DRAW_ELE ELE_TOP
DONE_ELE:
        POP AX    
        RET
MOVE_ELE ENDP

MOVE_ARROW PROC   
;this procedure updates position of arrows, checking if they have reached the other side
;if so, this procedure erases an arrow

;check ARROW1
        CMP ARROW1, 0FFFFh    ;if ARROW1 is used,
        JNZ MOVE_ARROW1       ;then, move ARROW1
        JMP CHECK_ARROW2      ;else, check ARROW2
MOVE_ARROW1:                  
        ERASE_ARROW ARROW1, ARROW1+2
        SUB ARROW1, 20
        CMP ARROW1, 100       ;if ARROW1 has not reached the other side,
        JGE UPDATE_ARROW1     ;then, update ARROW1
        MOV ARROW1, 0FFFFh    ;else delete ARROW1
        MOV ARROW1+2, 0FFFFh
        JMP CHECK_ARROW2
UPDATE_ARROW1:
        DRAW_ARROW ARROW1, ARROW1+2  ;else, update ARROW1

CHECK_ARROW2:
        CMP ARROW2, 0FFFFh    ;if ARROW2 is used,
        JNZ MOVE_ARROW2       ;move ARROW2
        JMP DONE_ARROW        ;then, this procedure is done
MOVE_ARROW2:                  
        ERASE_ARROW ARROW2, ARROW2+2
        SUB ARROW2, 20
        CMP ARROW2, 100       ;if ARROW2 has not reached the other side,
        JGE UPDATE_ARROW2     ;then, update ARROW2
        MOV ARROW2, 0FFFFh    ;else, delete ARROW2
        MOV ARROW2+2, 0FFFFh
        JMP DONE_ARROW
UPDATE_ARROW2:
        DRAW_ARROW ARROW2, ARROW2+2  ;else, update ARROW2

DONE_ARROW:                
        RET

MOVE_ARROW ENDP

SHOOT_ARROW PROC           
;this procedure launches an arrow,if there is an arrow available
;if not, this procedure does not do anything

        PUSH AX
;check whether ARROW1 is used
        CMP ARROW1, 0FFFFh      ;if ARROW1 is not used
        JZ  SHOOT_ARROW1        ;then, shoot ARROW1
        JMP CHECK_ARROW2_       ;else, check ARROW2

SHOOT_ARROW1:
        MOV ARROW1, 448
        MOV AX, ELE_TOP
        ADD AX, 20
        MOV ARROW1+2, AX
        DRAW_ARROW ARROW1, ARROW1+2  ;place ARROW1 next to the elevator
        CALL BEEP                    ;and, make sound
        JMP DONE_ARROW_

;check whether ARROW2 is used
CHECK_ARROW2_:        
        CMP ARROW2, 0FFFFh    ;if ARROW2 is not used
        JZ  SHOOT_ARROW2      ;then, shoot ARROW2
        JMP DONE_ARROW_       ;else, there is no arrow available

SHOOT_ARROW2:
        MOV ARROW2, 448       
        MOV AX, ELE_TOP
        ADD AX, 20
        MOV ARROW2+2, AX
        DRAW_ARROW ARROW2, ARROW2+2  ;place ARROW2 next to the elevator
        CALL BEEP                    ;and, make sound
        JMP DONE_ARROW_

DONE_ARROW_:
        POP AX                      
        RET
SHOOT_ARROW ENDP

        END





