;ChoongHong Oh

TITLE PGM4: BEEP
;sound generating procedure
        EXTRN TIMER_FLAG : BYTE
        PUBLIC BEEP
.MODEL SMALL

IF1
        INCLUDE macro.ASM
ENDIF

.CODE
BEEP PROC
;generate beeping sound
        SAVE_REGS <AX, CX>
;initialize timer
        MOV AL, 0B6h ;specify mode of operation
        OUT 43h, AL  ;write to port 43h
;load count
        MOV AX, 1193 ;count for 1000 Hz
        OUT 42h, AL  ;low byte
        MOV AL, AH   ;high byte
        OUT 42h, AL
;active speaker
        IN AL, 61h   ;read control port
        MOV AH, AL   ;save value in AH
        OR AL, 11b   ;set control bits
        OUT 61h, AL  ;active speaker
;500 ms delay loop
        MOV CX, 9    ;do 9 times
B_1:
        CMP TIMER_FLAG, 1 ;check timer flag
        JNE B_1           ;not set, loop back
        MOV TIMER_FLAG, 0 ;flag set, clear it
        LOOP B_1          ;repeat for next tick
;turn off tone
        MOV AL, AH   ;return old control value to AL
        OUT 61h, AL  ;restore control value

        RESTORE_REGS <CX, AX>
        RET
BEEP ENDP
        END

