
;************************************************************************
; Change attributes of character at Row, Column, using the foreground   *
; Fore and background Back.                                             *
; Entry: The follwing parameters are passed on the stack as words       *
;        Row, Col, Back, Fore                                           *
;************************************************************************

Row     EQU     [BP+4]
Column  EQU     [BP+6]
Back    EQU     [BP+8]
Fore    EQU     [BP+10]

        PUBLIC _Write_Attribute

_Write_Attribute PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    DI                      ;Preserve registers
        PUSH    ES

        ;--- Convert row and column to absolute offset within display buffer

        XOR     AX,AX                   ;Point ES to segment zero
        MOV     ES,AX
        MOV     AX,Row                  ;Fetch row number
        MOV     BX,ES:[BIOS_Columns]    ;Fetch columns per screen
        MUL     BX                      ;Compute absolute address as
        ADD     AX,Column               ; Column + Row * Columns)
        SHL     AX,1                    ; Account for attributes
        MOV     DI,AX                   ;Move address into register DI
        INC     DI                      ;Skip character code byte

        ;--- Determine and load segement of the display buffer

        MOV     AX,0B000H               ;Assume monochrome buffer address
        TEST    BYTE PTR ES:[BIOS_Equipment],2   ;Is mono attached?
        JNZ     Attr_Addr_Ok            ;...Yes, go load segment
        MOV     AX,0B800H               ;...No, change address to color
Attr_Addr_Ok:
        MOV     ES,AX                   ;Set segment of display buffer

        ;--- Compose attribute into a single byte and save into display buffer

        MOV     AH,Back                 ;Get the background attribute
        SHL     AH,1                    ;Shift 4 lower bits into upper nibble
        SHL     AH,1
        SHL     AH,1
        SHL     AH,1
        MOV     AL,Fore                 ;Get the background attribute
        AND     AL,0FH                  ;Keep only lower nibble
        OR      AL,AH                   ;Combine foreground and background
        STOSB                           ;Write it into display buffer

        POP     ES                      ;Restore registers
        POP     DI
        MOV     SP,BP
        POP     BP
        RET
_Write_Attribute ENDP
