
;************************************************************************
; Read character attribute at the cursor position at Row and Col        *
; Entry: Row,Col  Passed on the stack as integers                       *
; Exit:  AX       Backgrouond and foreground colors packed into a byte  *
;************************************************************************

Row     EQU     [BP+4]
Col     EQU     [BP+6]

        PUBLIC  _BIOS_Read_Attr

_BIOS_Read_Attr PROC NEAR
        PUSH    BP
        MOV     BP,SP

        MOV     DH,Row                  ;Set row and column
        MOV     DL,Col
        MOV     BH,0                    ;Select page 0
        MOV     AH,2                    ;Function = Set cursor position
        INT     10H                     ;Ask BIOS to set cursor position

        MOV     AH,8                    ;Function = READ CHARACTER & ATTRIBUTE
        MOV     BH,0                    ;from page 0
        INT     10H                     ;Ask BIOS to fetch attribute

        MOV     AL,AH                   ;Move attribute into lower byte
        XOR     AH,AH                   ;Clear upper byte of return value

        POP     BP
        RET
_BIOS_Read_Attr ENDP
