
;************************************************************************
; Using BIOS to scroll section of a text screen                         *
; Entry:        Up, Left        - Upper left row and column             *
;               Down, Right     - Lower right row and column            *
;               Count           - Number of lines to scroll             *
;************************************************************************

Up      EQU     BYTE PTR [BP+4]
Left    EQU     BYTE PTR [BP+6]
Down    EQU     BYTE PTR [BP+8]
Right   EQU     BYTE PTR [BP+10]
Count   EQU     BYTE PTR [BP+12]

        PUBLIC  _BIOS_Scroll_Text

_BIOS_Scroll_Text PROC NEAR
        PUSH    BP
        MOV     BP,SP
        MOV     BH,07           ;Attribute for 'blank' lines
        MOV     AL,Count        ;Number of lines to scroll
        MOV     CH,Up           ;Upper left corner into CX
        MOV     CL,Left
        MOV     DH,Down         ;Lower right corner into DX
        MOV     DL,Right
        CMP     Count,0         ;Is scroll up?
        JL      BIOS_Set_Down   ;...No, go scroll down
BIOS_Set_Up:                    ;...Yes, load scroll down fn
        MOV     AH,06H          ;Load service number
        JMP     BIOS_Do_Scroll
BIOS_Set_Down:
        MOV     AH,07H          ;Load service number
        NEG     AL              ;Make scroll value positive
BIOS_Do_Scroll:
        INT     10H                     ;Call BIOS to do the scroll
        POP     BP
        RET
_BIOS_Scroll_Text ENDP
