
;************************************************************************
; Get current cursor position by reading CRTC registers                 *
; Entry: Row   - Pointer to where to save current cursor row            *
;        Column- Pointer to where to save current cursor column         *
; Exit:  Values at the pointers are set to proper values                *
;************************************************************************

Row     EQU     [BP+4]
Column  EQU     [BP+6]

        PUBLIC  _Get_Cursor_Position

_Get_Cursor_Position PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    ES
        XOR     AX,AX                   ;Point ES to segment 0
        MOV     ES,AX
        MOV     DX,ES:[BIOS_CRT_Addr]   ;Load CRTC address
        MOV     AL,0EH                  ;Fetch index of cursor high
        OUT     DX,AL                   ;Select index
        INC     DX                      ;Load CRTC address
        IN      AL,DX                   ;Read the high address
        JMP     $+2
        MOV     BH,AL                   ;Save value in BH

        DEC     DX                      ;Load CRTC address
        MOV     AL,0FH                  ;Fetch index of cursor low
        OUT     DX,AL                   ;Select index
        INC     DX                      ;Load CRTC address
        IN      AL,DX                   ;Read the low part of address
        JMP     $+2

        MOV     AH,BH                   ;Fetch the high byte from earlier
        XOR     DX,DX                   ;convert to row and column
        MOV     BX,ES:[BIOS_Columns]    ;by dividing absolute address
        DIV     BX                      ;with columns
        MOV     BX,Row                  ;Fetch pointer where to save row
        MOV     [BX],AX                 ;Save row number
        MOV     BX,Column               ;Fetch pointer where to save column
        MOV     [BX],DX                 ;Save column number
        POP     ES
        POP     BP
        RET
_Get_Cursor_Position ENDP
